% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bactlist}
\alias{bactlist}
\title{Dataset with ~2500 microorganisms}
\format{A data.frame with 2507 observations and 10 variables:
\describe{
  \item{\code{bactid}}{ID of microorganism}
  \item{\code{bactsys}}{Bactsyscode of microorganism}
  \item{\code{family}}{Family name of microorganism}
  \item{\code{genus}}{Genus name of microorganism, like \code{"Echerichia"}}
  \item{\code{species}}{Species name of microorganism, like \code{"coli"}}
  \item{\code{subspecies}}{Subspecies name of bio-/serovar of microorganism, like \code{"EHEC"}}
  \item{\code{fullname}}{Full name, like \code{"Echerichia coli (EHEC)"}}
  \item{\code{type}}{Type of microorganism, like \code{"Bacterie"} en \code{"Schimmel/gist"} (these are Dutch)}
  \item{\code{gramstain}}{Gram of microorganism in Dutch, like \code{"Negatieve staven"}}
  \item{\code{aerobic}}{Type aerobe/anaerobe of bacteria}
}}
\source{
MOLIS (LIS of Certe) - \url{https://www.certe.nl}
}
\usage{
bactlist
}
\description{
A dataset containing all microorganisms of MOLIS. MO codes of the UMCG can be looked up using \code{\link{bactlist.umcg}}.
}
\seealso{
\code{\link{ablist}} \code{\link{bactlist.umcg}}
}
\keyword{datasets}
