% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mo_property.R
\name{mo_property}
\alias{mo_property}
\alias{mo_fullname}
\alias{mo_shortname}
\alias{mo_subspecies}
\alias{mo_species}
\alias{mo_genus}
\alias{mo_family}
\alias{mo_order}
\alias{mo_class}
\alias{mo_phylum}
\alias{mo_subkingdom}
\alias{mo_ref}
\alias{mo_type}
\alias{mo_TSN}
\alias{mo_gramstain}
\alias{mo_taxonomy}
\title{Property of a microorganism}
\usage{
mo_fullname(x, language = NULL, ...)

mo_shortname(x, language = NULL, ...)

mo_subspecies(x, language = NULL, ...)

mo_species(x, language = NULL, ...)

mo_genus(x, language = NULL, ...)

mo_family(x, ...)

mo_order(x, ...)

mo_class(x, ...)

mo_phylum(x, ...)

mo_subkingdom(x, ...)

mo_ref(x, ...)

mo_type(x, language = NULL, ...)

mo_TSN(x, ...)

mo_gramstain(x, language = NULL, ...)

mo_property(x, property = "fullname", language = NULL, ...)

mo_taxonomy(x, ...)
}
\arguments{
\item{x}{any (vector of) text that can be coerced to a valid microorganism code with \code{\link{as.mo}}}

\item{language}{language of the returned text, defaults to English (\code{"en"}) and can also be set with \code{\link{getOption}("AMR_locale")}. Either one of \code{"en"} (English), \code{"de"} (German), \code{"nl"} (Dutch), \code{"es"} (Spanish) or \code{"pt"} (Portuguese).}

\item{...}{other parameters passed on to \code{/link{as.mo}}}

\item{property}{one of the column names of one of the \code{\link{microorganisms}} data set or \code{"shortname"}}
}
\value{
A \code{list} (in case of \code{mo_taxonomy}) or a \code{character} otherwise
}
\description{
Use these functions to return a specific property of a microorganism from the \code{\link{microorganisms}} data set. All input values will be evaluated internally with \code{\link{as.mo}}.
}
\section{ITIS}{

\if{html}{\figure{itis_logo.jpg}{options: height=60px style=margin-bottom:5px} \cr}
This package contains the \strong{complete microbial taxonomic data} (with all  seven taxonomic ranks - from subkingdom to subspecies) from the publicly available Integrated Taxonomic Information System (ITIS, \url{https://www.itis.gov}).

The complete taxonomic kingdoms Bacteria, Fungi and Protozoa are included in this package, as well as all previously accepted names known to ITIS. Furthermore, the responsible authors and year of publication are available too. This allows users to use authoritative taxonomic information for their data analyses on any microorganisms, not only human pathogens.

ITIS is a partnership of U.S., Canadian, and Mexican agencies and taxonomic specialists [3].
}

\section{Source}{

[1] Becker K \emph{et al.} \strong{Coagulase-Negative Staphylococci}. 2014. Clin Microbiol Rev. 27(4): 870–926. \url{https://dx.doi.org/10.1128/CMR.00109-13}

[2] Lancefield RC \strong{A serological differentiation of human and other groups of hemolytic streptococci}. 1933. J Exp Med. 57(4): 571–95. \url{https://dx.doi.org/10.1084/jem.57.4.571}

[3] Integrated Taxonomic Information System (ITIS). Retrieved September 2018. \url{http://www.itis.gov}
}

\examples{
# All properties of Escherichia coli
mo_subkingdom("E. coli")      # "Negibacteria"
mo_phylum("E. coli")          # "Proteobacteria"
mo_class("E. coli")           # "Gammaproteobacteria"
mo_order("E. coli")           # "Enterobacteriales"
mo_family("E. coli")          # "Enterobacteriaceae"
mo_genus("E. coli")           # "Escherichia"
mo_species("E. coli")         # "coli"
mo_subspecies("E. coli")      # NA
mo_fullname("E. coli")        # "Escherichia coli"
mo_shortname("E. coli")       # "E. coli"
mo_gramstain("E. coli")       # "Gram negative"
mo_TSN("E. coli")             # 285
mo_type("E. coli")            # "Bacteria"
mo_ref("E. coli")             # "Castellani and Chalmers, 1919"


# Abbreviations known in the field
mo_genus("MRSA")              # "Staphylococcus"
mo_species("MRSA")            # "aureus"
mo_shortname("MRSA")          # "S. aureus"
mo_gramstain("MRSA")          # "Gram positive"

mo_genus("VISA")              # "Staphylococcus"
mo_species("VISA")            # "aureus"


# Known subspecies
mo_genus("doylei")            # "Campylobacter"
mo_species("doylei")          # "jejuni"
mo_fullname("doylei")         # "Campylobacter jejuni doylei"

mo_fullname("K. pneu rh")     # "Klebsiella pneumoniae rhinoscleromatis"
mo_shortname("K. pneu rh")    # "K. pneumoniae"


# Becker classification, see ?as.mo
mo_fullname("S. epi")                     # "Staphylococcus epidermidis"
mo_fullname("S. epi", Becker = TRUE)      # "Coagulase Negative Staphylococcus (CoNS)"
mo_shortname("S. epi")                    # "S. epidermidis"
mo_shortname("S. epi", Becker = TRUE)     # "CoNS"

# Lancefield classification, see ?as.mo
mo_fullname("S. pyo")                     # "Streptococcus pyogenes"
mo_fullname("S. pyo", Lancefield = TRUE)  # "Streptococcus group A"
mo_shortname("S. pyo")                    # "S. pyogenes"
mo_shortname("S. pyo", Lancefield = TRUE) # "GAS"


# Language support for German, Dutch, Spanish and Portuguese
mo_type("E. coli", language = "de")       # "Bakterium"
mo_type("E. coli", language = "nl")       # "Bacterie"
mo_type("E. coli", language = "es")       # "Bakteria"
mo_gramstain("E. coli", language = "de")  # "Gramnegativ"
mo_gramstain("E. coli", language = "nl")  # "Gram-negatief"
mo_gramstain("E. coli", language = "es")  # "Gram negativo"

mo_fullname("S. pyogenes",
            Lancefield = TRUE,
            language = "de")              # "Streptococcus Gruppe A"
mo_fullname("S. pyogenes",
            Lancefield = TRUE,
            language = "nl")              # "Streptococcus groep A"


# Complete taxonomy up to Subkingdom, returns a list
mo_taxonomy("E. coli")
}
\seealso{
\code{\link{microorganisms}}
}
