% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availability.R
\name{availability}
\alias{availability}
\title{Check availability of columns}
\usage{
availability(tbl, width = NULL)
}
\arguments{
\item{tbl}{a \code{data.frame} or \code{list}}

\item{width}{number of characters to present the visual availability, defaults to filling the width of the console}
}
\value{
\code{data.frame} with column names of \code{tbl} as row names
}
\description{
Easy check for availability of columns in a data set. This makes it easy to get an idea of which antibiotic combination can be used for calculation with e.g. \code{\link{portion_IR}}.
}
\section{Read more on our website!}{

On our website \url{https://msberends.gitlab.io/AMR} you can find \href{https://msberends.gitlab.io/AMR/articles/AMR.html}{a comprehensive tutorial} about how to conduct AMR analysis, the \href{https://msberends.gitlab.io/AMR/reference}{complete documentation of all functions} (which reads a lot easier than here in R) and \href{https://msberends.gitlab.io/AMR/articles/WHONET.html}{an example analysis using WHONET data}.
}

\examples{
availability(septic_patients)

library(dplyr)
septic_patients \%>\% availability()

septic_patients \%>\%
  select_if(is.rsi) \%>\%
  availability()

septic_patients \%>\%
  filter(mo == as.mo("E. coli")) \%>\%
  select_if(is.rsi) \%>\%
  availability()
}
