% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cochran.q.R
\name{cochran.q}
\alias{cochran.q}
\title{Perform Cochran Q test}
\usage{
cochran.q(
  y,
  groups,
  blocks,
  max.exact.perms = 1e+05,
  nsims.mc = 1e+05,
  seed = NULL,
  do.asymp = FALSE,
  do.exact = TRUE
)
}
\arguments{
\item{y}{Binary vector of same length as groups, blocks}

\item{groups}{Factor of same length as y, blocks with levels such that length(y) == nlevels(groups) * nlevels(blocks)}

\item{blocks}{Factor of same length as y, groups with levels such that length(y) == nlevels(groups) * nlevels(blocks)}

\item{max.exact.perms}{Maximum number of permutations allowed for exact calculations (defaults to \code{100000})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{100000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}

\item{do.asymp}{Boolean indicating whether or not to perform asymptotic calculations (defaults to \code{FALSE})}

\item{do.exact}{Boolean indicating whether or not to perform exact calculations (defaults to \code{TRUE})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{cochran.q()} performs the Cochran Q test and is used in chapter 7 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 7.8 from "Applied Nonparametric Statistical Methods" (5th edition)
cochran.q(ch7$outcome, ch7$climb, ch7$member, do.exact = FALSE, do.asymp = TRUE)

# Exercise 7.14 from "Applied Nonparametric Statistical Methods" (5th edition)
cochran.q(ch7$soc.media.use, ch7$participant, ch7$day, do.exact = FALSE, do.asymp = TRUE)

}
