% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/met.outstrength.R
\name{met.outstrength}
\alias{met.outstrength}
\title{Outstrength}
\usage{
met.outstrength(M, df = NULL, dfid = NULL)
}
\arguments{
\item{M}{a square adjacency matrix, or a list of square adjacency matrices, or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{df}{a data frame of same length as the input matrix or a list of data frames if argument \emph{M} is a list of matrices or an output of ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk}.}

\item{dfid}{an integer or a string indicating the column with individual ids in argument \emph{df}.}
}
\value{
\itemize{
\item An integer vector of nodes \emph{outstrength} if argument \emph{df} is \emph{NULL}.
\item A list of integer vectors of nodes \emph{outstrength} if argument \emph{M} is a list of matrices and if argument \emph{df} is \emph{NULL}.
\item A list of arguments df with a new column for nodes \emph{outstrength} titled 'outstrength', if argument \emph{df} is not \emph{NULL}.
\item A list of arguments df with a new column for nodes \emph{outstrength} if 1) argument \emph{df} is not \emph{NULL}, 2) argument \emph{M} is an output from ANT functions \emph{stat.ds.grp}, \emph{stat.df.focal}, \emph{stat.net.lk} for multiple matrices permutations, and 3) argument \emph{df} is a list of data frames of same length as argument \emph{M}. The name of the column of each element of the list is adapted according to argument value \emph{binary}.
}
}
\description{
Calculates the node metric outstrength for all vertices.
}
\details{
outstrength of a node \emph{i} is the sum of the strengths of all outgoing edges of a node \emph{i}.
}
\examples{
met.outstrength(sim.m)
head(sim.df)
met.outstrength(sim.m,df=sim.df)
}
\references{
Freeman, L. C. (1978). Centrality in social networks conceptual clarification. Social networks, 1(3), 215-239.

Barrat, A., Barthelemy, M., Pastor-Satorras, R., & Vespignani, A. (2004). The architecture of complex weighted networks. Proceedings of the National Academy of Sciences of the United States of America, 101(11), 3747-3752.

Sosa, S. (2018). Social Network Analysis, \emph{in}: Encyclopedia of Animal Cognition and Behavior. Springer.
}
\author{
Sebastian Sosa, Ivan Puga-Gonzalez.
}
