% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{apci.plot.hexagram}
\alias{apci.plot.hexagram}
\title{Plot the hexagram heatmap}
\usage{
apci.plot.hexagram(
  model,
  age,
  period,
  first_age,
  first_period,
  interval,
  first_age_isoline = NULL,
  first_period_isoline = NULL,
  isoline_interval = NULL,
  color_scale = NULL,
  color_map = NULL,
  line_width = 0.5,
  line_color = "grey",
  label_size = 0.5,
  label_color = "black",
  scale_units = "Quintile",
  wrap_cohort_labels = TRUE,
  quantile = NULL
)
}
\arguments{
\item{model}{A list recording the results from function \code{apci}.}

\item{age}{An object of class character representing the age group index
taking on a small number of distinct values in the data. Usually, the vector
should be converted to a factor (or the terms of "category" and "enumerated
type").}

\item{period}{An object of class character, similar to the argument of age,
representing the time period index in the data.}

\item{first_age}{The first age group.}

\item{first_period}{The first period group.}

\item{interval}{The width of age and period groups.}

\item{first_age_isoline}{Isoline for the first age group.}

\item{first_period_isoline}{Isoline for the first period group.}

\item{isoline_interval}{Interval of isoline.}

\item{color_scale}{A vector including two numbers
indicating the limit of the values to be plotted. The
first number is the minimum value to be visualized and the
second is the maximum value to be visualized. If NULL, the
algorithm will automatically select the limits from the data
(estimation results) to set up the scale.}

\item{color_map}{A vector, representing the color palettes to
be used in the figure. The default setting is greys if color_map is
\code{NULL}. Alternations, for example, can be c("blue", "yellow"),
blues, etc.}

\item{line_width}{Width of lines. Default is 0.5.}

\item{line_color}{Line colors. Default is grey.}

\item{label_size}{Axis label size. Default is 0.5.}

\item{label_color}{Axis label color. Default is Black.}

\item{scale_units}{Units of scales.}

\item{wrap_cohort_labels}{Display the cohort label or not. The default is
\code{TRUE}.}

\item{quantile}{A number valued between 0 and 1, representing the
desirable percentiles to be used in visualizing the data or model.
If \code{NULL}, the original scale of the outcome variable will be used.}
}
\value{
A hexagram visualizing the APC-I model results.
}
\description{
Plot the cohort effect in the style of hexagram
}
\examples{
# load package
library("APCI")
# load data
test_data <- APCI::women9017
test_data$acc <- as.factor(test_data$acc)
test_data$pcc <- as.factor(test_data$pcc)
test_data$educc <- as.factor(test_data$educc)
test_data$educr <- as.factor(test_data$educr)

# fit APC-I model
APC_I <- APCI::apci(outcome = "inlfc",
                    age = "acc",
                    period = "pcc",
                    cohort = "ccc",
                    weight = "wt",
                    data = test_data,dev.test=FALSE,
                    print = TRUE,
                    family = "gaussian")
summary(APC_I)

# plot hexagram
apci.plot.hexagram(model=APC_I,age="acc",period="pcc",first_age = 20,
                   first_period = 1940, interval = 5)
}
