% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joinAQuadtrees.R
\name{joinAQuadtrees}
\alias{joinAQuadtrees}
\title{Join two AQuadtree obtjects from the same area, to compare their data}
\usage{
joinAQuadtrees(qt1, qt2, withResiduals = FALSE, mean.1 = NULL, mean.2 = NULL)
}
\arguments{
\item{qt1}{object of class "AQuadtree" containing the first object to join.}

\item{qt2}{object of class "AQuadtree" containing the second object to join.}

\item{withResiduals}{logical indicating if \code{residual} cells should be
maintained (TRUE) or not (FALSE, default).}

\item{mean.1}{character or character vector specifying the columns in the
first AQuadtreeto which a weighted mean should be computed. By default
the aggregation function used is \code{sum}.}

\item{mean.2}{character or character vector specifying the columns in the
first AQuadtreeto which a weighted mean should be computed. By default
the aggregation function used is \code{sum}.}
}
\value{
AQuadtree with the information of the two given objects summarised
at the lowest level shared by both objects.
}
\description{
Given two objects of class AQuadtree for the same area, wich, for instance,
may contain data from two different periods, \code{joinAQuadtrees}
returns a new object of class AQuadtree with the common zones at the lowest
shared level, summarising the data from both AQuadtrees.
}
\details{
The function \code{joinAQuadtrees} creates a new AQuadtree object from two
given AQuadtree objects with data from the same area. The data of the
two given objects is summarised at the smallest possible cells shared by
both given objects. All the input data is maintained on the new created
object. This function can be used to join the different attributes from
the same area or information from different periods.
}
\examples{
data("CharlestonPop")
CharlestonPop.AQT_1<-AQuadtree(CharlestonPop, layers = 2)
CharlestonPop.AQT_2<-AQuadtree(CharlestonPop, colnames="sex",
       thresholdField=c("sex.male", "sex.female"), layers = 2)
CharlestonPop.AQT_1_2<-joinAQuadtrees(CharlestonPop.AQT_1, CharlestonPop.AQT_2)

}
