% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvcokmUtils.R
\name{mvcokm}
\alias{mvcokm}
\title{Construct the mvcokm object}
\usage{
mvcokm(
  formula = list(~1, ~1),
  output,
  input,
  cov.model = "matern_5_2",
  nugget.est = FALSE,
  prior = list(),
  opt = list(),
  NestDesign = TRUE,
  tuning = list(),
  info = list()
)
}
\arguments{
\item{formula}{a list of \eqn{s} elements, each of which contains the formula to specify fixed basis functions or regressors.}

\item{output}{a list of \eqn{s} elements, each of which contains a matrix of computer model outputs.}

\item{input}{a list of \eqn{s} elements, each of which contains a matrix of inputs.}

\item{cov.model}{a string indicating the type of covariance
function in the PP cokriging models. Current covariance functions include
\describe{
\item{exp}{product form of exponential covariance functions.} 
\item{matern_3_2}{product form of Matern covariance functions with 
smoothness parameter 3/2.}
\item{matern_5_2}{product form of Matern covariance functions with
smoothness parameter 5/2.}
\item{Gaussian}{product form of Gaussian covariance functions.}
\item{powexp}{product form of power-exponential covariance functions with roughness parameter fixed at 1.9.}
}}

\item{nugget.est}{a logical value indicating whether the nugget is included or not. Default value is \code{FALSE}.}

\item{prior}{a list of arguments to setup the prior distributions with the jointly robust prior as default
\describe{
 \item{name}{the name of the prior. Current implementation includes 
 \code{JR}, \code{Reference}, \code{Jeffreys}, \code{Ind_Jeffreys}}
 \item{hyperparam}{hyperparameters in the priors. 
 For jointly robust (JR) prior, three parameters are included: 
\eqn{a} refers to the polynomial penalty to avoid singular correlation 
  matrix with a default value 0.2; \eqn{b} refers to the exponenetial penalty to avoid 
  diagonal correlation matrix with a default value 1; nugget.UB is the upper
bound of the nugget variance with default value 1, which indicates that the
nugget variance has support (0, 1).}

}}

\item{opt}{a list of arguments to setup the \code{\link{optim}} routine.}

\item{NestDesign}{a logical value indicating whether the 
experimental design is hierarchically nested within each level
of the code.}

\item{tuning}{a list of arguments to control the MCEM algorithm for non-nested
design. It includes the arguments 
\describe{
   \item{maxit}{the maximum number of MCEM iterations.}
   \item{tol}{a tolerance to stop the MCEM algorithm. If the parameter 
   difference between any two consecutive MCEM algorithm is less than 
   this tolerance, the MCEM algorithm is stopped.}
   \item{n.sample}{the number of Monte Carlo samples in the 
   MCEM algorithm.}
   \item{verbose}{a logical value to show the MCEM iterations if it is true.}
}}

\item{info}{a list that contains 
\describe{
 \item{iter}{number of iterations used in the MCEM algorithm}
 \item{eps}{parameter difference after the MCEM algorithm stops}
}}
}
\description{
This function constructs the mvcokm object in
  autogressive cokriging models for multivariate outputs. The model is known as the parallel partial (PP) cokriging emulator.
}
\seealso{
\code{\link{ARCokrig}}, \code{\link{mvcokm.fit}}, \code{\link{mvcokm.predict}}, \code{\link{mvcokm.condsim}}
}
\author{
Pulong Ma <mpulong@gmail.com>
}
