% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aa_common_docs.R
\name{common_docs}
\alias{common_docs}
\title{Common arguments and documentation for various functions}
\arguments{
\item{project_dir}{Character. Directory where project files are stored. File
paths will be used to extract information and must actually exist.}

\item{project_files}{Character. Vector of project file paths. These paths can
be absolute or relative to the working directory, and don't actually need
to point to existing files unless you plan to use \code{clean_gps()} or other
sampling steps down the line. Must be provided if \code{project_dir} is \code{NULL}.}

\item{subset}{Character. Text pattern to mark a subset of files/directories
to either \code{"keep"} or \code{"omit"} (see \code{subset_type})}

\item{subset_type}{Character. Either \code{keep} (default) or \code{omit}
files/directories which match the pattern in \code{subset}.}

\item{meta}{Data frame. Recording metadata. Output of \code{clean_metadata()}.}

\item{meta_sites}{(Spatial) Data frame. Recording metadata with added
coordinates. Output of \code{clean_metadata()} and then \code{add_sites()} (with
either \code{clean_gps()} or \code{clean_site_index()}).}

\item{col_site_id}{Column. Unquoted column containing site strata IDs
(defaults to \code{site_id}).}

\item{date}{Logical. Whether to summarize output by date (as well as
\code{site_id} and \code{aru_id}. Default \code{FALSE}.}

\item{path}{Character. Path to wave file.}

\item{dir_out}{Character. Output directory.}

\item{quiet}{Logical. Whether to suppress progress messages and other
non-essential updates.}
}
\description{
Common arguments and documentation for various functions
}
\details{
Use \verb{@inheritParams common_docs} to include the above in any function
documentation with a matching argument (will only include matching args)
}
\keyword{internal}
