% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_dirs.R
\name{create_dirs}
\alias{create_dirs}
\title{Create directory structure for recording folders}
\usage{
create_dirs(
  plots,
  site_ids,
  base_dir = NULL,
  dir_list = FALSE,
  dry_run = TRUE,
  expect_dirs = FALSE
)
}
\arguments{
\item{plots}{Character vector. Hexagon or cluster names for folder names.}

\item{site_ids}{Character vector. Site IDs. Should include the plot/cluster
id in the name.}

\item{base_dir}{Character. Base directory to build directory structure in.}

\item{dir_list}{Logical. Whether to return a vector of directories (to be)
created (defaults to \code{FALSE}).}

\item{dry_run}{Logical. Whether to do a dry-run of the process (i.e. do not
actually create directories; defaults to \code{TRUE})}

\item{expect_dirs}{Logical. Expect that directories may already exist? Default
(\code{FALSE}) is to stop if directories to be created already exist.}
}
\value{
If \code{dir_list = TRUE}, returns a list of directories (to be) created.
If not a dry run, also creates the folder structure.
}
\description{
Create a set of nested folders for storing ARU recordings by plots and sites.
}
\examples{
# Default is to do a dry-run (don't actually create the directories)
create_dirs(
  plots = c("river1", "river2", "river3"),
  site_ids = c(
    "river1_sm01", "river1_sm02", "river2_sm03", "river2_sm04",
    "river3_sm05", "river3_sm06"
  ),
  base_dir = "Recordings"
)

# Get a list of directories which would be created
create_dirs(
  plots = c("river1", "river2", "river3"),
  site_ids = c(
    "river1_sm01", "river1_sm02", "river2_sm03", "river2_sm04",
    "river3_sm05", "river3_sm06"
  ),
  base_dir = "Recordings", dir_list = TRUE
)

\dontshow{if (dir.exists("Recordings")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create directories AND return a list of those created
d <- create_dirs(
  plots = c("river1", "river2", "river3"),
  site_ids = c(
    "river1_sm01", "river1_sm02", "river2_sm03", "river2_sm04",
    "river3_sm05", "river3_sm06"
  ),
  base_dir = "Recordings", dir_list = TRUE, expect_dirs =TRUE,
  dry_run = FALSE
)
d
\dontshow{\}) # examplesIf}
}
