% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_ASGS.R
\name{install_ASGS}
\alias{install_ASGS}
\title{Install a (nearly) complete package of the Australian Statistical Geography Standard}
\usage{
install_ASGS(
  temp.tar.gz = tempfile(fileext = ".tar.gz"),
  overwrite = FALSE,
  lib = .libPaths()[1],
  repos = getOption("repos"),
  type = getOption("pkgType", "source"),
  ...,
  .reinstalls = 4L,
  url.tar.gz = NULL,
  verbose = FALSE
)
}
\arguments{
\item{temp.tar.gz}{A file to save the ASGS tarball after download. Since the package is quite large,
it may be prudent to set this to a non-temporary file so that subsequent attempts to reinstall do not require additional downloads.}

\item{overwrite}{(logical, default: \code{FALSE}). If \code{temp.tar.gz} already exists, should it be overwritten or should there be an error?}

\item{lib, repos, type}{Passed to \code{\link[utils]{install.packages}} when installing ASGS's dependencies (if not already installed).}

\item{...}{Other arguments passed to \code{\link[utils]{install.packages}}.}

\item{.reinstalls}{Number of times to attempt to install any (absent) dependencies of \code{ASGS}
before aborting. Try restarting R rather than setting this number too high.}

\item{url.tar.gz}{The URL of the tarball to be downloaded. Not normally
needed by users, but may be in case the link becomes fallow, and
a new one becomes available before the release of a new package entirely.}

\item{verbose}{(logical, default: \code{FALSE}) Report logic paths?}
}
\value{
\code{temp.tar.gz}, invisibly.
}
\description{
The ASGS package provides a nearly comprehensive set of shapefiles, both unmodified and simplified from the Australian Bureau of Statistics. The ASGS package is over 700 MB, so cannot be hosted on CRAN. This function allows the package to be distributed almost as conveniently as through CRAN.

Should you find ASGS lacks some shapefile that you require, please file an issue requesting it be added.

Note that the package is quite large and provides no limits on access, so it is preferred that distribution occur as far as possible via other channels to ensure the method of access provided here is sustainable.
}
