#' Create an Alarm Metrics Object
#'
#' This function creates an object of class "alarm_metrics" from a list of metric matrices.
#' It's used to organize and structure the results from various epidemic alarm metrics calculations.
#'
#' @param metrics_list A list containing matrices for different alarm metrics
#'        (FAR, ADD, AATQ, FATQ, WAATQ, WFATQ).
#'
#' @return An object of class "alarm_metrics" which is a list with the input metrics.
#' @export
#'
#' @examples
#' # Generate sample alarm metrics data
#' set.seed(123)
#' generate_metric_matrix <- function() {
#'   matrix(runif(15 * 11), nrow = 15, ncol = 11,
#'          dimnames = list(paste("Lag", 1:15),
#'                          paste("Threshold", seq(0.1, 0.6, by = 0.05))))
#' }
#'
#' sample_metrics <- list(
#'   FAR = generate_metric_matrix(),
#'   ADD = generate_metric_matrix(),
#'   AATQ = generate_metric_matrix(),
#'   FATQ = generate_metric_matrix(),
#'   WAATQ = generate_metric_matrix(),
#'   WFATQ = generate_metric_matrix()
#' )
#'
#' # Create an alarm_metrics object
#' alarm_metrics_obj <- alarm_metrics(sample_metrics)
#'
#' # Check the class of the resulting object
#' class(alarm_metrics_obj)
#'
#' # Access a specific metric
#' head(alarm_metrics_obj$AATQ)
#'
#' # Use with other functions (assuming they're defined in your package)
#' # plot(alarm_metrics_obj, metric = "FAR")
alarm_metrics <- function(metrics_list) {
  class(metrics_list) <- c("alarm_metrics", class(metrics_list))
  metrics_list
}
