% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_households.R
\name{simulate_households}
\alias{simulate_households}
\title{Simulate total households and individuals data}
\usage{
simulate_households(children_df, noChildren_df)
}
\arguments{
\item{children_df}{data frame output from house_children() function}

\item{noChildren_df}{data frame output from house_noChildren() function}
}
\value{
list of two data frames; simulated individuals data
and simulated households data
}
\description{
Creates two simulated populations, households and individuals
}
\examples{
# Simulate catchment areas
catch_df <- catchment_sim(4, 5, shape = 3.5, rate = 2.8)

# Simulate elementary schools using default gamma distribution
elementary_df <- elementary_pop(catch_df, shape = 5.1, rate = 0.015)

# Simulate households with children
house_children <- subpop_children(elementary_df, n = 2,
                                  prop_parent_couple = 0.7,
                                  prop_children_couple = c(0.3, 0.5, 0.2),
                                  prop_children_lone = c(0.4, 0.4, 0.2),
                                  prop_elem_age = 0.2)

# Simulate households without children using pre-specified proportions
house_nochildren <- subpop_noChildren(house_children, elementary_df,
                                   prop_house_size = c(0.2, 0.3, 0.25, 0.15, 0.1),
                                   prop_house_Children = 0.3)

# simulate households and individuals data
simulation <- simulate_households(house_children, house_nochildren)

}
