% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step1_down_basic.R
\name{step1_down_basic}
\alias{step1_down_basic}
\title{Basic version Step1 Down Model}
\usage{
step1_down_basic(
  data,
  y,
  .time,
  K = NULL,
  C = NULL,
  validation = NULL,
  parms = NULL,
  reparameterisation = FALSE,
  zero_order = FALSE,
  ...
)
}
\arguments{
\item{data}{Dataframe containing accelerated stability data (required).}

\item{y}{Name of decreasing variable (e.g. concentration) contained within data
(required).}

\item{.time}{Time variable contained within data (required).}

\item{K}{Kelvin variable (numeric or column name) (optional).}

\item{C}{Celsius variable (numeric or column name) (optional).}

\item{validation}{Validation dummy variable, the column must contain only
1s and 0s, 1 for validation data and 0 for fit data. (column name) (optional).}

\item{parms}{Starting values for the parameters as a list - k1, k2, k3, and c0.}

\item{reparameterisation}{Use alternative parameterisation of the one-step
model which aims to reduce correlation between k1 and k2.}

\item{zero_order}{Set kinetic order, k3, to zero (straight lines).}

\item{...}{Further arguments to passed to minpack.lm.}
}
\value{
The fit object
}
\description{
Quickly fit the one-step Šesták–Berggren kinetic model.
}
\details{
Fit the one-step Šesták–Berggren kinetic (non-linear) model using
accelerated stability data that has been stored in an R data frame. Only the model
fit object is returned and a summary of the model fit is printed in the console, allowing
for more rapid testing than step1_down(). Kinetic parameters (k1, k2 and, if used, k3) are
retained in the model even if one or more of these parameters turn out to be non-significant.
Further arguments relating to model fitting, such as setting lower bounds for one or more model
parameters, may be passed.
}
\examples{
#load antigenicity and potency data.
data(antigenicity)
data(potency)

#Use of the step1_down_basic function with C column defined.
fit1 <- step1_down_basic(data = antigenicity, y = "conc", .time = "time", C = "Celsius")

#Basic use of the step1_down_basic function with K column defined & Validation data segmented out.
fit2 <- step1_down_basic(data = antigenicity, y = "conc", .time = "time", K = "K",
validation = "validA")

#When zero_order = FALSE, the output suggests using zero_order = TRUE for Potency dataset.
fit3 <- step1_down_basic(data = potency, y = "Potency", .time = "Time",C = "Celsius",
  reparameterisation = FALSE, zero_order = TRUE)

#reparameterisation is TRUE.
fit4 <- step1_down_basic(data = antigenicity, y = "conc", .time = "time",C = "Celsius",
  reparameterisation = TRUE)

#Use a custom lower bound for k1 (default is 0).
fit5 <- step1_down_basic(data = potency, y = "Potency", .time = "Time", C = "Celsius",
  reparameterisation = TRUE, zero_order = TRUE, lower = c(-Inf, 0, 0))

}
