% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayes4Mixtures.R
\name{Bayes4Mixtures}
\alias{Bayes4Mixtures}
\title{Posterioris of Bayes Theorem}
\usage{
Bayes4Mixtures(Data, Means, SDs, Weights, IsLogDistribution = 0 * Means,
  PlotIt = FALSE, CorrectBorders = FALSE, Color = NULL,
  xlab = "Data", lwd = 4)
}
\arguments{
\item{Data}{vector (1:N) of data points}

\item{Means}{vector[1:L] of Means of Gaussians (of GMM),L == Number of Gaussians}

\item{SDs}{vector of standard deviations, estimated Gaussian Kernels, has to be the same length as Means}

\item{Weights}{vector of relative number of points in Gaussians (prior probabilities), has to be the same length as Means}

\item{IsLogDistribution}{Optional, ==1 if distribution(i) is a LogNormal, default vector of zeros of length L}

\item{PlotIt}{Optional, Default: FALSE; TRUE do a Plot}

\item{CorrectBorders}{Optional, ==TRUE data at right borders of GMM distribution will be assigned to last gaussian, left border vice versa. (default ==FALSE) normal Bayes Theorem}

\item{Color}{Optional, character vector of colors, default rainbow()}

\item{xlab}{Optional, label of x-axis, default 'Data', see intern R documentation}

\item{lwd}{Width of Line, see intern R documentation}
}
\value{
List With 
\describe{
  \item{Posteriors:}{(1:N,1:L) of Posteriors corresponding to Data}
  \item{NormalizationFactor:}{(1:N) denominator of Bayes theorem corresponding to Data}
}
}
\description{
Calculates the posterioris of Bayes theorem
}
\details{
See conference presentation for further explanation.
}
\references{
Thrun M.C.,Ultsch, A.: Models of Income Distributions for Knowledge Discovery, European Conference on Data Analysis, DOI 10.13140/RG.2.1.4463.0244, Colchester 2015

\strong{See Also}

BayesDecisionBoundaries,AdaptGauss
}
\author{
Catharina Lippmann, Onno Hansen-Goos, Michael Thrun
}
