% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{get.plotted.events}
\alias{get.plotted.events}
\title{Get info about the plotted events.}
\usage{
get.plotted.events(plot.type = c("baseR", "SVG")[1], suppress.warnings = FALSE)
}
\arguments{
\item{plot.type}{Can be either "baseR" or "SVG" and specifies to which type of plotting
the mapping applies.}

\item{suppress.warnings}{\emph{Logical}, if \code{TRUE} don't show any
warnings.}
}
\value{
A \code{data.frame} that, besides the info about each event, also
contains info about:
\itemize{
 \item the corresponding follow-up and observation windows (and, for
 \code{CMA8}, the "real" observation window), given as the corners of the area
 \emph{.X...START}, \emph{.X...END}, \emph{.Y...START} and \emph{.Y...END}
 (where the mid dot stands for FUW, OW and ROW, respectively).
 \item the area occupied by the graphic representation of the event given by
 its four corners \emph{.X.START}, \emph{.X.END}, \emph{.Y.START} and
 \emph{.Y.END}, as well as the line width \emph{.EV.LWD}.
 \item the dose text's (if any) position (\emph{.X.DOSE}, \emph{.Y.DOSE}) and
 font size \emph{.FONT.SIZE.DOSE}.
 \item if event corvered and not covered are plotted, also give their areas as
 \emph{.X.EVC.START}, \emph{.X.EVC.END}, \emph{.Y.EVC.START}, \emph{.Y.EVC.END},
 \emph{.X.EVNC.START}, \emph{.X.EVNC.END}, \emph{.Y.EVNC.START} and
 \emph{.Y.EVNC.END}.
 \item the continuation lines area as \emph{.X.CNT.START}, \emph{.X.CNT.END},
 \emph{.Y.CNT.START} and \emph{.Y.CNT.END}.
 \item and the corresponding summary CMA (if any) given as the area
 \emph{.X.SCMA.START}, \emph{.X.SCMA.END}, \emph{.Y.SCMA.START} and
 \emph{.Y.SCMA.END}.
}
Please note that even if with follow-up and ("real") observation window, and
the summary CMA info is repeated for each event, they really make sense at
the level of the patient.
}
\description{
Returns a \code{data.frame} where each row contains info about one plotted event;
the order of the rows reflects the y-axis (first row on bottom).
}
\details{
This is intended for advanced users only.
}
\examples{
cma7 <- CMA7(data=med.events[med.events$PATIENT_ID \%in\% c(1,2),],
             ID.colname="PATIENT_ID",
             event.date.colname="DATE",
             event.duration.colname="DURATION",
             event.daily.dose.colname="PERDAY",
             medication.class.colname="CATEGORY",
             followup.window.start=0,
             followup.window.start.unit="days",
             followup.window.duration=2*365,
             followup.window.duration.unit="days",
             observation.window.start=30,
             observation.window.start.unit="days",
             observation.window.duration=365,
             observation.window.duration.unit="days",
             date.format="\%m/\%d/\%Y",
             summary="Base CMA");
plot(cma7);
tmp <- get.plotted.events();
head(tmp);
# "Mask" the first event:
rect(tmp$.X.START[1], tmp$.Y.START[1]-0.5, tmp$.X.END[1], tmp$.Y.END[1]+0.5,
     col=adjustcolor("white",alpha.f=0.75), border="black");
# "Mask" the first patient's summary CMA:
rect(tmp$.X.SCMA.START[1], tmp$.Y.SCMA.START[1],
     tmp$.X.SCMA.END[1], tmp$.Y.SCMA.END[1],
     col=adjustcolor("white",alpha.f=0.75), border="black");
}
