% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adherer.R
\name{subsetCMA}
\alias{subsetCMA}
\title{Restrict a CMA object to a subset of patients.}
\usage{
subsetCMA(cma, patients, suppress.warnings)
}
\arguments{
\item{cma}{a CMA object.}

\item{patients}{a list of patient IDs to keep.}

\item{suppress.warnings}{\emph{Logical}, if \code{TRUE} don't show any
warnings.}
}
\value{
a CMA object containing only the information for the given patients.
}
\description{
Restrict a CMA object to a subset of patients.
}
\examples{
cma1 <- CMA1(data=med.events,
             ID.colname="PATIENT_ID",
             event.date.colname="DATE",
             event.duration.colname="DURATION",
             followup.window.start=30,
             observation.window.start=30,
             observation.window.duration=365,
             date.format="\%m/\%d/\%Y"
            );
getCMA(cma1);
cma1a <- subsetCMA(cma1, patients=c(1:3,7));
cma1a; getCMA(cma1a);
}
