% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dict_function.R
\name{DICT}
\alias{DICT}
\title{Analysis: Completely randomized design evaluated over time}
\usage{
DICT(
  trat,
  time,
  response,
  alpha.f = 0.05,
  alpha.t = 0.05,
  mcomp = "tukey",
  theme = theme_classic(),
  geom = "bar",
  xlab = "Independent",
  ylab = "Response",
  p.adj = "holm",
  dec = 3,
  fill = "gray",
  error = TRUE,
  textsize = 12,
  labelsize = 5,
  pointsize = 4.5,
  family = "sans",
  sup = 0,
  addmean = FALSE,
  legend = "Legend",
  ylim = NA,
  width.bar = 0.2,
  size.bar = 0.8,
  posi = c(0.1, 0.8),
  xnumeric = FALSE,
  all.letters = FALSE
)
}
\arguments{
\item{trat}{Numerical or complex vector with treatments}

\item{time}{Numerical or complex vector with times}

\item{response}{Numerical vector containing the response of the experiment.}

\item{alpha.f}{Level of significance of the F test (\emph{default} is 0.05)}

\item{alpha.t}{Significance level of the multiple comparison test (\emph{default} is 0.05)}

\item{mcomp}{Multiple comparison test (Tukey (\emph{default}), LSD ("lsd"), Scott-Knott ("sk"), Duncan ("duncan") and Kruskal-Wallis ("kw"))}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{geom}{Graph type (columns - "bar" or segments "point")}

\item{xlab}{treatments name (Accepts the \emph{expression}() function)}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{p.adj}{Method for adjusting p values for Kruskal-Wallis ("none","holm","hommel", "hochberg", "bonferroni", "BH", "BY", "fdr")}

\item{dec}{Number of cells}

\item{fill}{Defines chart color (to generate different colors for different treatments, define fill = "trat")}

\item{error}{Add error bar}

\item{textsize}{Font size of the texts and titles of the axes}

\item{labelsize}{Font size of the labels}

\item{pointsize}{Point size}

\item{family}{Font family}

\item{sup}{Number of units above the standard deviation or average bar on the graph}

\item{addmean}{Plot the average value on the graph (\emph{default} is TRUE)}

\item{legend}{Legend title}

\item{ylim}{y-axis scale}

\item{width.bar}{width error bar}

\item{size.bar}{size error bar}

\item{posi}{Legend position}

\item{xnumeric}{Declare x as numeric (\emph{default} is FALSE)}

\item{all.letters}{Adds all label letters regardless of whether it is significant or not.}
}
\value{
The function returns the p-value of Anova, the assumptions of normality of errors, homogeneity of variances and independence of errors, multiple comparison test, as well as a line graph
}
\description{
Function of the AgroR package for the analysis of experiments conducted in a completely randomized, qualitative, uniform qualitative design with multiple assessments over time, however without considering time as a factor.
}
\note{
The ordering of the graph is according to the sequence in which the factor levels are arranged in the data sheet. The bars of the column and segment graphs are standard deviation.
}
\examples{
rm(list=ls())
data(simulate1)
attach(simulate1)
with(simulate1, DICT(trat, tempo, resp))
with(simulate1, DICT(trat, tempo, resp,geom="bar",sup=40))
with(simulate1, DICT(trat, tempo, resp,geom="point",sup=40,))
}
\references{


Principles and procedures of statistics a biometrical approach Steel, Torry and Dickey. Third Edition 1997

Multiple comparisons theory and methods. Departament of statistics the Ohio State University. USA, 1996. Jason C. Hsu. Chapman Hall/CRC.

Practical Nonparametrics Statistics. W.J. Conover, 1999

Ramalho M.A.P., Ferreira D.F., Oliveira A.C. 2000. Experimentacao em Genetica e Melhoramento de Plantas. Editora UFLA.

Scott R.J., Knott M. 1974. A cluster analysis method for grouping mans in the analysis of variance. Biometrics, 30, 507-512.
}
\seealso{
\link{DIC}, \link{DBCT}, \link{DQLT}
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
\keyword{Experimental}
\keyword{dict}
