% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dic_function.R
\name{DIC}
\alias{DIC}
\title{Analysis: Completely randomized design}
\usage{
DIC(
  trat,
  response,
  norm = "sw",
  homog = "bt",
  alpha.f = 0.05,
  alpha.t = 0.05,
  quali = TRUE,
  mcomp = "tukey",
  grau = 1,
  transf = 1,
  constant = 0,
  test = "parametric",
  mcompNP = "LSD",
  p.adj = "holm",
  geom = "bar",
  theme = theme_classic(),
  ylab = "Response",
  sup = NA,
  CV = TRUE,
  xlab = "",
  fill = "lightblue",
  angle = 0,
  family = "sans",
  textsize = 12,
  labelsize = 4,
  dec = 3,
  width.column = NULL,
  width.bar = 0.3,
  addmean = TRUE,
  errorbar = TRUE,
  posi = "top",
  point = "mean_sd",
  angle.label = 0,
  ylim = NA
)
}
\arguments{
\item{trat}{Numerical or complex vector with treatments}

\item{response}{Numerical vector containing the response of the experiment.}

\item{norm}{Error normality test (\emph{default} is Shapiro-Wilk)}

\item{homog}{Homogeneity test of variances (\emph{default} is Bartlett)}

\item{alpha.f}{Level of significance of the F test (\emph{default} is 0.05)}

\item{alpha.t}{Significance level of the multiple comparison test (\emph{default} is 0.05)}

\item{quali}{Defines whether the factor is quantitative or qualitative (\emph{default} is qualitative)}

\item{mcomp}{Multiple comparison test (Tukey (\emph{default}), LSD, Scott-Knott and Duncan)}

\item{grau}{Degree of polynomial in case of quantitative factor (\emph{default} is 1)}

\item{transf}{Applies data transformation (\emph{default} is 1; for log consider 0, `angular` for angular transformation)}

\item{constant}{Add a constant for transformation (enter value)}

\item{test}{"parametric" - Parametric test or "noparametric" - non-parametric test}

\item{mcompNP}{Multiple comparison test (LSD (\emph{default}) or dunn)}

\item{p.adj}{Method for adjusting p values for Kruskal-Wallis ("none","holm","hommel", "hochberg", "bonferroni", "BH", "BY", "fdr")}

\item{geom}{Graph type (columns, boxes or segments)}

\item{theme}{ggplot2 theme (\emph{default} is theme_classic())}

\item{ylab}{Variable response name (Accepts the \emph{expression}() function)}

\item{sup}{Number of units above the standard deviation or average bar on the graph}

\item{CV}{Plotting the coefficient of variation and p-value of Anova (\emph{default} is TRUE)}

\item{xlab}{Treatments name (Accepts the \emph{expression}() function)}

\item{fill}{Defines chart color (to generate different colors for different treatments, define fill = "trat")}

\item{angle}{x-axis scale text rotation}

\item{family}{Font family}

\item{textsize}{Font size}

\item{labelsize}{Label size}

\item{dec}{Number of cells}

\item{width.column}{Width column if geom="bar"}

\item{width.bar}{Width errorbar}

\item{addmean}{Plot the average value on the graph (\emph{default} is TRUE)}

\item{errorbar}{Plot the standard deviation bar on the graph (In the case of a segment and column graph) - \emph{default} is TRUE}

\item{posi}{Legend position}

\item{point}{Defines whether to plot mean ("mean"), mean with standard deviation ("mean_sd" - \emph{default}) or mean with standard error ("mean_se"). For quali=FALSE or quali=TRUE. For parametric test it is possible to plot the square root of QMres (mean_qmres)}

\item{angle.label}{label angle}

\item{ylim}{Define a numerical sequence referring to the y scale. You can use a vector or the `seq` command.}
}
\value{
The table of analysis of variance, the test of normality of errors (Shapiro-Wilk ("sw"), Lilliefors ("li"), Anderson-Darling ("ad"), Cramer-von Mises ("cvm"), Pearson ("pearson") and Shapiro-Francia ("sf")), the test of homogeneity of variances (Bartlett ("bt") or Levene ("levene")), the test of independence of Durbin-Watson errors, the test of multiple comparisons (Tukey ("tukey"), LSD ("lsd"), Scott-Knott ("sk") or Duncan ("duncan")) or adjustment of regression models up to grade 3 polynomial, in the case of quantitative treatments. Non-parametric analysis can be used by the Kruskal-Wallis test. The column, segment or box chart for qualitative treatments is also returned. The function also returns a standardized residual plot.
}
\description{
Statistical analysis of experiments conducted in a completely randomized and balanced design with a factor considering the fixed model. The function presents the option to use non-parametric method or transform the dataset.
}
\note{
Enable ggplot2 package to change theme argument.

The ordering of the graph is according to the sequence in which the factor levels are arranged in the data sheet. The bars of the column and segment graphs are standard deviation.

Post hoc test in nonparametric is using the criterium Fisher's least significant difference (p-adj="holm").

CV and p-value of the graph indicate coefficient of variation and p-value of the F test of the analysis of variance.

In the final output when transformation (transf argument) is different from 1, the columns resp and respo in the mean test are returned, indicating transformed and non-transformed mean, respectively.
}
\examples{
library(AgroR)
data(pomegranate)

with(pomegranate, DIC(trat, WL, ylab = "Weight loss (\%)")) # tukey
with(pomegranate, DIC(trat, WL, mcomp = "sk", ylab = "Weight loss (\%)"))
with(pomegranate, DIC(trat, WL, mcomp = "duncan", ylab = "Weight loss (\%)"))

#=============================
# Kruskal-Wallis
#=============================
with(pomegranate, DIC(trat, WL, test = "noparametric", ylab = "Weight loss (\%)"))


#=============================
# chart type
#=============================
with(pomegranate, DIC(trat, WL, geom="point", ylab = "Weight loss (\%)"))
with(pomegranate, DIC(trat, WL, ylab = "Weight loss (\%)", xlab="Treatments"))

#=============================
# quantitative factor
#=============================
data("phao")
with(phao, DIC(dose,comp,quali=FALSE,grau=2,
               xlab = expression("Dose"~(g~vase^-1)),
               ylab="Leaf length (cm)"))

#=============================
# data transformation
#=============================
data("pepper")
with(pepper, DIC(Acesso, VitC, transf = 0,ylab="Vitamin C"))
}
\references{
Principles and procedures of statistics a biometrical approach Steel, Torry and Dickey. Third Edition 1997

Multiple comparisons theory and methods. Departament of statistics the Ohio State University. USA, 1996. Jason C. Hsu. Chapman Hall/CRC.

W.J. Conover, Practical Nonparametrics Statistics. 1999

Ramalho M.A.P., Ferreira D.F., Oliveira A.C. 2000. Experimentacao em Genetica e Melhoramento de Plantas. Editora UFLA.

Scott R.J., Knott M. 1974. A cluster analysis method for grouping mans in the analysis of variance. Biometrics, 30, 507-512.

Mendiburu, F., and de Mendiburu, M. F. (2019). Package ‘agricolae’. R Package, Version, 1-2.

Hothorn, T. et al. Package ‘lmtest’. Testing linear regression models. https://cran. r-project. org/web/packages/lmtest/lmtest. pdf. Accessed, v. 6, 2015.
}
\seealso{
\link{DBC} \link{DQL}
}
\author{
Gabriel Danilo Shimizu, \email{shimizu@uel.br}

Leandro Simoes Azeredo Goncalves

Rodrigo Yudi Palhaci Marubayashi
}
\keyword{DIC}
\keyword{Experimental}
