% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flowgrap.R
\name{flowgrap}
\alias{flowgrap}
\title{Flow graphic of nozzles on spray bar}
\usage{
flowgrap(
  file,
  pointsize = 3.5,
  xsup = 1.1,
  xinf = 0.9,
  pointcolor = "red",
  xlab = "Nozzle number",
  ylab = NA
)
}
\arguments{
\item{file}{Numerical vector with the flows}

\item{pointsize}{Point size (\emph{default} 3.5)}

\item{xsup}{Upper limit}

\item{xinf}{Bottom limit}

\item{pointcolor}{Point color (red)}

\item{xlab}{x axis legend}

\item{ylab}{y axis legend}
}
\value{
Returns graph of ggplot2
}
\description{
This is a function to check the conditions of the spray nozzles
}
\examples{
resp=c(881,854,865,876,906.3,
874.7,868.3,878.7,872.7,901.7,
823.3,889.7,861.3,900.3,890.3,
886.7,916.7,872,912.7,894)
flowgrap(resp)
# flowgrap("file.xlsx")
}
\references{
ANDEF Associacao Nacional de Defesa Vegetal. Manual de tecnologia de aplicacao de produtos fitossanitarios. Campinas: Linea Creativa, 2004. 50p.

BOLLER, W.; RAETANO, C. G. Bicos e pontas de pulverizacao de energia hidraulica, regulagens e calibracao de pulverizadores de barras. In: ANTUNIASSI, U. R.; BOLLER, W. (Organizadores). Tecnologia de aplicacao para culturas anuais. Passo Fundo: Aldeia Norte; Botucatu: FEPAF, 2011. p.51-82.

SPRAYING SYSTEMS CO. Catalogo 51A-PT - Produtos de pulverizacao para agricultura. Wheaton: Spraying Systems Co., 2014. 160p.
}
\author{
Rodrigo Yudi Palhaci Marubayashi, \email{marubayashi@uel.br}

Gabriel Danilo Shimizu

Otavio Jorge Grigoli Abi Saab
}
