% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-plot.R
\name{pas_palette}
\alias{pas_palette}
\title{Color palettes for PurpleAir}
\usage{
pas_palette(pas = NULL, paletteName = "AQI", parameter = "pm25_1hr", ...)
}
\arguments{
\item{pas}{Enhanced data frame of PurpleAir synoptic data.}

\item{paletteName}{A predefined color palette name. Can be of the following:
\itemize{
\item{"AQI"}
\item{"humidity}
\item{"temperature}
\item{"distance"}
}}

\item{parameter}{Value to generate colors for, e.g. \code{pm25_1hr}.}

\item{...}{Additional arguments passed on to \code{leaflet::color~} functions.}
}
\value{
An object that consists of a label and color dataframe, and
calculated color values from PurpleAir sensors
}
\description{
Generates color palettes for PurpleAir synoptic data with the 
intention of having a reproducible functional color generator.
}
\note{
The \code{paletteName} parameter can take the name of an RColorBrewer
paeltte, \emph{e.g.} \code{"BuPu"} or \code{"Greens"}.
}
