% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensor_loadMonth.R
\name{sensor_loadMonth}
\alias{sensor_loadMonth}
\title{Load hourly-aggregated PurpleAir data for a month}
\usage{
sensor_loadMonth(
  collection = "scaqmd",
  datestamp = NULL,
  timezone = "America/Los_Angeles"
)
}
\arguments{
\item{collection}{Name associated with the collection.}

\item{datestamp}{A date string in ymd order.}

\item{timezone}{Timezone used to interpret \code{datestamp}.}
}
\value{
An object of class "pa_timeseries".
}
\description{
A pre-generated \code{airsensor} object will be loaded for
the given month. Archived data for SCAQMD sensors go back to January, 2018.

The \code{datestamp} can must be in the following format:

\itemize{
\item{\code{"YYYYmm"}}
}

By default, the current month is loaded.

Each \code{airsensor} object contains data from a named collection of 
PurpleAir sensors.
}
\examples{
\donttest{
library(AirSensor)

setArchiveBaseUrl("http://data.mazamascience.com/PurpleAir/v1")

sensor_loadMonth("scaqmd", 202005) \%>\%
  PWFSLSmoke::monitor_timeseriesPlot(style = 'gnats')
}
}
\seealso{
\link{pat_createNew}
}
