% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensor_filter.R
\name{sensor_filter}
\alias{sensor_filter}
\title{Data filtering for AirSensor objects}
\usage{
sensor_filter(sensor = NULL, ...)
}
\arguments{
\item{sensor}{An AirSensor object.}

\item{...}{Logical predicates defined in terms of the variables in 
\code{sensor$data}.}
}
\value{
A subset of the incoming \emph{sensor}.
}
\description{
A generalized data filter for \emph{sensor} objects to 
choose rows/cases where conditions are true.  Multiple conditions are 
combined with \code{&} or seperated by a comma. Only rows where the condition 
evaluates to TRUE are kept.Rows where the condition evaluates to \code{NA}
are dropped.
}
\note{
Filtering predicates are applied to the \code{data} dataframe within
the \emph{sensor} object.
}
\examples{
library(AirSensor)

twenties <- sensor_filter(example_sensor, 
                          example_sensor$data$`392a12065eb9940d_5192` <  30, 
                          example_sensor$data$`392a12065eb9940d_5192` >= 20)
head(twenties$data)

}
\seealso{
\link{sensor_filterDate}

\link{sensor_filterMeta}
}
