% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{SumCountSS}
\alias{SumCountSS}
\title{Allelic Sum Test from Sumstats}
\usage{
SumCountSS(anno, beta, ld, se, weights, return_beta = FALSE)
}
\arguments{
\item{anno}{(snps x 1) annotation vector with integer values in 1 through
the number of annotation categories L.}

\item{beta}{(snps x 1) vector of effect sizes for
the coding genetic variants within a gene.}

\item{ld}{(snps x snps) matrix of correlations among the genetic variants.}

\item{se}{(snps x 1) vector of standard errors for the effect sizes.}

\item{weights}{(L x 1) vector of annotation category weights. Note that the
number of annotation categories L is inferred from the length of \code{weights}.}

\item{return_beta}{Return estimated effect sizes and standard errors?
Default: FALSE.}
}
\value{
If \code{return_beta}, a list containing the category effect sizes,
standard errors, and the p-value. Otherwise, the numeric p-value only.
}
\description{
Allelic Sum Test from Sumstats
}
