% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AlphaPartSubset.R
\name{AlphaPartSubset}
\alias{AlphaPartSubset}
\title{AlphaPartSubset.R}
\usage{
AlphaPartSubset(x, paths = NULL)
}
\arguments{
\item{x}{AlphaPart or summaryAlphaPart, object from the \code{AlphaPart(...)} or \code{summary(AlphaPart(...), ...)} call.}

\item{paths}{Character, names of paths to be kept.}
}
\value{
An object of class \code{AlphaPart} or \code{summaryAlphaPart} with only some paths.
Meta information in slot "info" is modified as well.
}
\description{
A function to choose the partition paths to keep.
}
\details{
Displaying results of partitions for many paths is often confusing.
This function helps in selecting only paths of interest.
Unspecified paths are removed from the input object \code{x}.
Meta information is modified accordingly. Default setting does nothing.
}
\examples{
## Small pedigree with additive genetic (=breeding) values
ped <- data.frame(  id=c(  1,   2,   3,   4,   5,   6),
                  fid=c(  0,   0,   2,   0,   4,   0),
                  mid=c(  0,   0,   1,   0,   3,   3),
                  loc=c("A", "B", "A", "B", "A", "A"),
                  gen=c(  1,   1,   2,   2,   3,   3),
                 trt1=c(100, 120, 115, 130, 125, 125),
                 trt2=c(100, 110, 105, 100,  85, 110))

## Partition additive genetic values
(tmp <- AlphaPart(x=ped, colAGV=c("trt1", "trt2")))

## Keep some partitions (working on object of class AlphaPart)
(tmp2 <- AlphaPartSubset(x=tmp, paths="A"))

## Summarize by generation
(tmpS <- summary(tmp, by="gen"))

## Keep some partitions (working on object of class summaryAlphaPart)
(tmpS2 <- AlphaPartSubset(x=tmpS, paths="A"))

## ... must be equal to
(tmpS3 <- summary(tmp2, by="gen"))
}
\seealso{
\code{\link[AlphaPart]{AlphaPart}} for the main method,
\code{\link[AlphaPart]{summary.AlphaPart}} for summary method that works on output of \code{AlphaPart},
\code{\link[AlphaPart]{AlphaPartSum}} for sum method.
}
