% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrids.R
\name{hybridCross}
\alias{hybridCross}
\title{Hybrid crossing}
\usage{
hybridCross(
  females,
  males,
  crossPlan = "testcross",
  returnHybridPop = FALSE,
  simParam = NULL
)
}
\arguments{
\item{females}{female population, an object of \code{\link{Pop-class}}}

\item{males}{male population, an object of \code{\link{Pop-class}}}

\item{crossPlan}{either "testcross" for all possible combinantions 
or a matrix with two columns for designed crosses}

\item{returnHybridPop}{should results be returned as 
\code{\link{HybridPop-class}}. If false returns results as 
\code{\link{Pop-class}}. Population must be fully inbred if TRUE.}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\description{
A convience function for hybrid plant breeding simulations. Allows for 
easy specification of a test cross scheme and/or creation of an object 
of \code{\link{HybridPop-class}}. Note that the \code{\link{HybridPop-class}} 
should only be used if the parents were created using the \code{\link{makeDH}} 
function or \code{\link{newPop}} using inbred founders. The id for 
new individuals is [mother_id]_[father_id]
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=2, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)

#Create population
pop = newPop(founderPop, simParam=SP)

#Make crosses for full diallele
pop2 = hybridCross(pop, pop, simParam=SP)

}
