% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybrids.R
\name{setPhenoGCA}
\alias{setPhenoGCA}
\title{Set GCA as phenotype}
\usage{
setPhenoGCA(
  pop,
  testers,
  use = "pheno",
  h2 = NULL,
  H2 = NULL,
  varE = NULL,
  reps = 1,
  fixEff = 1L,
  p = NULL,
  inbred = FALSE,
  onlyPheno = FALSE,
  simParam = NULL
)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{testers}{an object of \code{\link{Pop-class}}}

\item{use}{true genetic value (\code{gv}) or phenotypes (\code{pheno}, default)}

\item{h2}{a vector of desired narrow-sense heritabilities for
each trait. See details.}

\item{H2}{a vector of desired broad-sense heritabilities for
each trait. See details.}

\item{varE}{error (co)variances for traits. See details.}

\item{reps}{number of replications for phenotype. See details.}

\item{fixEff}{fixed effect to assign to the population. Used 
by genomic selection models only.}

\item{p}{the p-value for the environmental covariate 
used by GxE traits. If NULL, a value is
sampled at random.}

\item{inbred}{are both pop and testers fully inbred. They are only 
fully inbred if created by \code{\link{newPop}} using inbred founders 
or by the \code{\link{makeDH}} function}

\item{onlyPheno}{should only the phenotype be returned, see return}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns an object of \code{\link{Pop-class}} or 
a matrix if onlyPheno=TRUE
}
\description{
Calculates general combining ability from a set of testers and 
returns these values as phenotypes for a population.
}
\details{
There are three arguments for setting the error variance of a 
phenotype: h2, H2, and varE. The user should only use one of these 
arguments. If the user supplies values for more than one, only one 
will be used according to order in which they are listed above.

The h2 argument allows the user to specify the error variance 
according to narrow-sense heritability. This calculation uses the
additive genetic variance and total genetic variance in the founder 
population. Thus, the heritability relates to the founder population 
and not the current population.

The H2 argument allows the user to specify the error variance 
according to broad-sense heritability. This calculation uses the
total genetic variance in the founder population. Thus, the heritability 
relates to the founder population and not the current population.

The varE argument allows the user to specify the error variance
directly. The user may supply a vector describing the error variance 
for each trait or supply a matrix that specify the covariance of 
the errors.

The reps parameter is for convenient representation of replicated data. 
It is intended to represent replicated yield trials in plant 
breeding programs. In this case, varE is set to the plot error and 
reps is set to the number of plots per entry. The resulting phenotype 
represents the entry-means.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=10, nChr=1, segSites=10, inbred=TRUE)

#Set simulation parameters
SP = SimParam$new(founderPop)
SP$addTraitA(10)

#Create population
pop = newPop(founderPop, simParam=SP)

#Set phenotype to average per
pop2 = setPhenoGCA(pop, pop, use="gv", inbred=TRUE, simParam=SP)

}
