% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{editGenomeTopQtl}
\alias{editGenomeTopQtl}
\title{Edit genome - the top QTL}
\usage{
editGenomeTopQtl(pop, ind, nQtl, trait = 1, increase = TRUE, simParam = NULL)
}
\arguments{
\item{pop}{an object of \code{\link{Pop-class}}}

\item{ind}{a vector of individuals to edit}

\item{nQtl}{number of QTL to edit}

\item{trait}{which trait effects should guide selection of the top QTL}

\item{increase}{should the trait value be increased or decreased}

\item{simParam}{an object of \code{\link{SimParam}}}
}
\value{
Returns an object of \code{\link{Pop-class}}
}
\description{
Edits the top QTL (with the largest additive effect) to a homozygous
state for the allele increasing. Only nonfixed QTL are edited The gv slot is
recalculated to reflect the any changes due to editing, but other slots remain the same.
}
\examples{
#Create founder haplotypes
founderPop = quickHaplo(nInd=2, nChr=1, segSites=10)

#Set simulation parameters
SP = SimParam$new(founderPop)
\dontshow{SP$nThreads = 1L}
SP$addTraitA(10)

#Create population
pop = newPop(founderPop, simParam=SP)

#Change up to 10 loci for individual 1
pop2 = editGenomeTopQtl(pop, ind=1, nQtl=10, simParam=SP)

}
