% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.r
\name{write.AmigaBasic}
\alias{write.AmigaBasic}
\title{Write an AmigaBasic object to a file}
\usage{
write.AmigaBasic(x, file)
}
\arguments{
\item{x}{The \code{\link[=AmigaBasic]{AmigaBasic()}} class object that needs to be
stored.}

\item{file}{A \code{character} string specifying the file location
to which \code{x} (an \code{\link[=AmigaBasic]{AmigaBasic()}} object) needs to be written.}
}
\value{
Invisibly returns the result of the call of \code{close} to the
file connection.
}
\description{
Write an \code{\link[=AmigaBasic]{AmigaBasic()}} class object to a file in its binary format.
}
\details{
This function encodes the Amiga Basic code in its binary format
(using \code{\link[=as.raw]{as.raw()}}) and writes it to a file. The file
can also be stored onto a virtual Amiga disk
(\code{\link[adfExplorer:adf_file_con]{adf_file_con()}}).
}
\examples{
## First create an AmigaBasic object:
bas <- as.AmigaBasic("PRINT \"hello world!\"")

## write to tempdir:
write.AmigaBasic(bas, file.path(tempdir(), "helloworld.bas"))
}
\seealso{
Other AmigaBasic.operations: 
\code{\link{AmigaBasic.reserved}()},
\code{\link{AmigaBasicBMAP}},
\code{\link{AmigaBasic}},
\code{\link{[.AmigaBasic}()},
\code{\link{as.AmigaBasicBMAP}()},
\code{\link{as.AmigaBasic}()},
\code{\link{as.character}()},
\code{\link{check.names.AmigaBasic}()},
\code{\link{names.AmigaBasic}()},
\code{\link{rawToAmigaBasicBMAP}()},
\code{\link{rawToAmigaBasic}()},
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{read.AmigaBasic}()}

Other io.operations: 
\code{\link{read.AmigaBasicBMAP}()},
\code{\link{read.AmigaBasicShape}()},
\code{\link{read.AmigaBasic}()},
\code{\link{read.AmigaBitmapFontSet}()},
\code{\link{read.AmigaBitmapFont}()},
\code{\link{read.AmigaIcon}()},
\code{\link{read.SysConfig}()},
\code{\link{read.iff}()},
\code{\link{write.AmigaBasicShape}()},
\code{\link{write.AmigaBitmapFont}()},
\code{\link{write.AmigaIcon}()},
\code{\link{write.SysConfig}()},
\code{\link{write.iff}()}
}
\author{
Pepijn de Vries
}
\concept{AmigaBasic.operations}
\concept{io.operations}
