% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterObject.R
\name{getCSPEstimates}
\alias{getCSPEstimates}
\title{Return Codon Specific Paramters (or write to csv) estimates as data.frame}
\usage{
getCSPEstimates(parameter, filename = NULL, CSP = "Mutation", mixture = 1,
  samples = 10)
}
\arguments{
\item{parameter}{parameter an object created by \code{initializeParameterObject}.}

\item{filename}{Posterior estimates will be written to file instead of returned if specified (format: csv).}

\item{CSP}{which type of codon specific parameter should be returned (mutation (default) or selection)}

\item{mixture}{estimates for which mixture should be returned}

\item{samples}{The number of samples used for the posterior estimates.}
}
\value{
returns a data.frame with the posterior estimates of the models 
codon specific parameters or writes it directly to a csv file if \code{filename} is specified
}
\description{
\code{getCSPEstimates} returns the codon specific
parameter estimates for a given parameter and mixture or write it to a csv file.
}
\examples{
 
genome_file <- system.file("extdata", "genome.fasta", package = "AnaCoDa")

genome <- initializeGenomeObject(file = genome_file)
sphi_init <- c(1,1)
numMixtures <- 2
geneAssignment <- sample(1:2, length(genome), replace = TRUE) # random assignment to mixtures
parameter <- initializeParameterObject(genome = genome, sphi = sphi_init, 
                                       num.mixtures = numMixtures, 
                                       gene.assignment = geneAssignment, 
                                       mixture.definition = "allUnique")
model <- initializeModelObject(parameter = parameter, model = "ROC")
samples <- 2500
thinning <- 50
adaptiveWidth <- 25
mcmc <- initializeMCMCObject(samples = samples, thinning = thinning, 
                             adaptive.width=adaptiveWidth, est.expression=TRUE, 
                             est.csp=TRUE, est.hyper=TRUE, est.mix = TRUE) 
divergence.iteration <- 10
\dontrun{
runMCMC(mcmc = mcmc, genome = genome, model = model, 
        ncores = 4, divergence.iteration = divergence.iteration)

## return estimates for codon specific parameters
csp_mat <- getCSPEstimates(parameter, CSP="Mutation")

# write the result directly to the filesystem as a csv file. No values are returned
getCSPEstimates(parameter, , filename=file.path(tempdir(), "csp_out.csv"), CSP="Mutation")

}

}
