% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Conover_ImanTest.R
\name{ConoverTest}
\alias{ConoverTest}
\title{Conover-Iman Test for Multiple Comparisons (Non-Parametric)}
\usage{
ConoverTest(formula, data, alpha = 0.05, method.p = "holm")
}
\arguments{
\item{formula}{A formula of the form \code{y ~ group}, where \code{y} is a numeric variable
and \code{group} is a factor indicating group membership.}

\item{data}{A data frame containing the variables specified in the formula.}

\item{alpha}{Significance level for hypothesis testing (default is 0.05).}

\item{method.p}{Method used to adjust p-values for multiple comparisons (default is \code{"holm"}).}
}
\value{
An object of class \code{"conover"} and \code{"comparaciones"}, containing:
\itemize{
  \item \code{Resultados}: A data frame with pairwise comparisons, t-statistics, raw and adjusted p-values, and significance markers.
  \item \code{Promedios}: A named numeric vector with mean ranks for each group.
  \item \code{Orden_Medias}: A character vector with group names sorted from highest to lowest rank.
  \item \code{Metodo}: A string describing the method used ("Conover (no parametrico)").
}
}
\description{
Performs non-parametric pairwise comparisons based on rank-transformed data using
the Conover-Iman procedure. This method is typically applied as a post hoc test
following a significant Kruskal-Wallis test to identify specific group differences.
}
\details{
The Conover-Iman test uses rank-based t-statistics, offering improved statistical
power over Dunn's test while maintaining flexibility in sample size.

Advantages:
- More powerful than Dunn’s test, especially with moderate group differences.
- Robust to non-normal data and suitable for ordinal or skewed distributions.
- Allows for unequal sample sizes across groups.

Disadvantages:
- Sensitive to heteroscedasticity (non-constant variances).
- Requires appropriate p-value adjustment to control the family-wise error rate.
}
\examples{
data(d_e, package = "Analitica")
ConoverTest(Sueldo_actual ~ labor, data = d_e)


}
\references{
Conover, W. J. & Iman, R. L. (1979). "Multiple comparisons using rank sums." \emph{Technometrics}, 21(4), 489–495.
}
