% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMTest_permutations.R
\name{BMpTest}
\alias{BMpTest}
\title{Brunner-Munzel Test (Permutation Version) for Two Independent Groups}
\usage{
BMpTest(
  grupo1,
  grupo2,
  alpha = 0.05,
  alternative = c("two.sided", "less", "greater"),
  nperm = 10000,
  seed = NULL
)
}
\arguments{
\item{grupo1}{A numeric vector representing the first group.}

\item{grupo2}{A numeric vector representing the second group.}

\item{alpha}{Significance level (default is 0.05).}

\item{alternative}{Character string specifying the alternative hypothesis:
one of \code{"two.sided"} (default), \code{"greater"}, or \code{"less"}.}

\item{nperm}{Number of permutations to perform (default = 10000).}

\item{seed}{Optional random seed for reproducibility (default is NULL).}
}
\value{
An object of class \code{"comparacion"} and \code{"brunnermunzel_perm"}, containing:
\itemize{
  \item \code{Resultados}: A data frame with comparison name, mean difference, empirical p-value, and significance.
  \item \code{Promedios}: A named numeric vector of group means.
  \item \code{Orden_Medias}: Group names ordered by their mean.
  \item \code{Metodo}: Description of the method used.
}
}
\description{
Performs the Brunner-Munzel test using a permutation approach, suitable for
comparing two independent samples when the assumption of equal variances may not hold.
}
\details{
This version computes an empirical p-value based on resampling, without relying
on the t-distribution approximation.
}
\examples{
data(d_e, package = "Analitica")
g1 <- d_e$Sueldo_actual[d_e$labor == 1]
g2 <- d_e$Sueldo_actual[d_e$labor == 2]
resultado <- BMpTest(g1, g2)
summary(resultado)

}
\references{
Brunner, E., & Munzel, U. (2000). "The nonparametric Behrens-Fisher problem:
Asymptotic theory and a small-sample approximation." \emph{Biometrical Journal}, 42(1), 17–25.
}
