% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing_plot.R
\name{missing_values_plot}
\alias{missing_values_plot}
\title{Missing Values Plot}
\usage{
missing_values_plot(df, percentage = TRUE, row = TRUE)
}
\arguments{
\item{df}{The input data frame.}

\item{percentage}{A logical argument (default: TRUE) to generate a percentage plot.}

\item{row}{A logical argument (default: TRUE) to generate a row plot.}
}
\value{
A list of plots, including a percentage plot and/or a row plot.
}
\description{
This function generates plots to visualize missing values in a data frame. It includes two types of plots:
 - A percentage plot: Displays the percentage of missing values for each variable, allowing quick identification
    of variables with high missingness.
 - A row plot: Illustrates the distribution of missing values across rows, providing insights into patterns of missingness.
}
\examples{
\donttest{
data("airquality")
missing_values_plot(df = airquality, percentage = TRUE, row = TRUE)
}
}
