% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{AM_VnkNegBin}
\alias{AM_VnkNegBin}
\title{Compute the value V(n,k), needed to caclulate the eppf of a Finite Dirichlet process when the prior on the component-weigts of the mixture is a Dirichlet with parameter \code{gamma} (i.e. when unnormailized weights are distributed as Gamma(\eqn{\gamma},1) ) when the prior on the number of componet is Negative Binomial with parameter \code{r} and \code{p}with  mean is mu =1+ r*p/(1-p) TODO: CHECK THIS FORMULA!!!. See Section 9.1.1 of the Paper Argiento de Iorio 2019 for more details}
\usage{
AM_VnkNegBin(n, r, p, gam)
}
\arguments{
\item{n}{The sample size}

\item{r}{The dispersion parameter \code{r} of Negative Binomial}

\item{p}{The probability of failure parameter \code{p} of Negative Binomial}

\item{gam}{The \code{gamma} parameter of the Dirichlet}
}
\value{
A vector of length n, reporting the values \code{V(n,k)} for \code{k=1,...,n}
}
\description{
There are no default values.
}
\examples{
n=1000
r=1000
p=0.5
gam=0.5
vnk= AM_VnkNegBin(n,r,p,gam);
stir= AM_compute_stirling_ricor_log(n, gam)
plot(exp(vnk+stir+(1:n)*log(gam)))
sum(exp(vnk+stir))
}
\keyword{cluster}
\keyword{number}
\keyword{of}
\keyword{prior}
