% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prog.R
\name{MultiHPD}
\alias{MultiHPD}
\title{Bayesian highest posterior density regions for a series of MCMC chains}
\usage{
MultiHPD(data, position, level=0.95)
}
\arguments{
  \item{data}{dataframe containing the output of the MCMC algorithm. The MCMC samples should be in calendar year (BC/AD). }
  \item{position}{numeric vector containing the position of the column corresponding to the MCMC chains of interest}
  \item{level}{probability corresponding to the level of confidence}
}
\value{
Returns a matrix of values containing the level of confidence and the endpoints of each interval for each variable of the MCMC chain. The name of the resulting rows are the positions of the corresponding columns in the CSV file. The result is given in calendar year (in format BC/AD).
}
\description{
Estimation of the highest posterior density regions for each variables of simulated Markov chain. This function uses the "hdr" function oincluded in the package "hdrcde.

}
\author{
  Anne Philippe <Anne.Philippe@univ-nantes.fr> and

  Marie-Anne Vibet <Marie-Anne.Vibet@univ-nantes.fr>
}
\references{
Hyndman, R.J. (1996) Computing and graphing highest density regions. American Statistician, 50, 120-126.

}
\examples{
  data(Events)
  MultiHPD(Events, c(2,4,3), 0.95)
}
\keyword{ highest posterior density regions }
