% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dta.R
\name{dta}
\alias{dta}
\title{dta}
\usage{
dta(RM_sample, mod_1, mod_2, pairs_1, pairs_2, DM_mesh_1, DM_mesh_2,
  DM_set_1, DM_set_2, method = c("euclidean"))
}
\arguments{
\item{RM_sample}{3D array: 3D landmark configurations of the reference sample}

\item{mod_1}{numeric vector: vector containing the position of which landmarks belong to the first module}

\item{mod_2}{numeric vector: vector containing the position of which landmarks belong to the second module}

\item{pairs_1}{matrix: a X x 2 matrix containing the indices of right and left landmarks of the first module}

\item{pairs_2}{matrix: a X x 2 matrix containing the indices of right and left landmarks of the second module}

\item{DM_mesh_1}{mesh3d: mesh of the disarticulated model (first module)}

\item{DM_mesh_2}{mesh3d: mesh of the disarticulated model (second module)}

\item{DM_set_1}{matrix: 3D landmark set of the first module acquired on the disarticulated model}

\item{DM_set_2}{matrix: 3D landmark set of the second module acquired on the disarticulated model}

\item{method}{character: specify method to be used to individuate the best DTA ("euclidean" or "procrustes")}
}
\value{
AM_mesh mesh3d: mesh of the aligned model

AM_set matrix: landmark configuration of the aligned model

AM_id character: name of the item of the reference sample resulted as best DTA

AM_SF_1 numeric: scale factor used to scale the reference set (first module)

AM_SF_2 numeric: scale factor used to scale the reference set (second module)

distance numeric: distance between the landmark configuration of the aligned and the reference model

tot_proc numeric vector: procrustes distances between aligned and reference models (all DTAs)

tot_eucl numeric vector: euclidean distances between aligned and reference models (all DTAs)

setarray 3D array: landmark configurations of the disarticulated model aligned on each item of the reference sample
}
\description{
This function applyes the Digital Alignment Tool (DTA) on a disarticulated model using a reference sample
}
\examples{
## Load and plot the disarticulated model of the Homo sapiens case study
library(compositions)
library(rgl)
data(DM_base_sur)
data(DM_face_sur)
open3d()
wire3d(DM_base_sur,col="white")
wire3d(DM_face_sur,col="white")
## Load the landmark configurations associated to the DM 
data(DM_set)
## Load the reference sample 
data(RMs_sets)
## Define the landmarks belonging to the first and second module
mod_1<-c(1:17) #cranial base
mod_2<-c(18:32) #facial complex
## Define the paired landmarks for each module (optional symmetrization process)
pairs_1<-cbind(c(4,6,8,10,12,14,16),c(5,7,9,11,13,15,17))
pairs_2<-cbind(c(23,25,27,29,31),c(24,26,28,30,32))
## Run DTA
ex.dta<-dta(RM_sample=RMs_sets, mod_1=mod_1, mod_2=mod_2, pairs_1=pairs_1, pairs_2=pairs_2,
DM_mesh_1=DM_base_sur,DM_mesh_2=DM_face_sur, DM_set_1= DM_set[mod_1,], DM_set_2=DM_set[mod_2,])
## Print the name of the best RM 
ex.dta$AM_id
## Save the mesh and the landmark set of the AM
AM_mesh<-ex.dta$AM_mesh
AM_set<-ex.dta$AM_set
## Plot the aligned 3D model
library(compositions)
library(rgl)
open3d()
wire3d(AM_mesh,col="white")
plot3D(AM_set,bbox=FALSE,add=TRUE)
}
\author{
Antonio Profico, Costantino Buzi, Marina Melchionna, Paolo Piras, Pasquale Raia, Alessio Veneziano
}
