% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NPT_main.R
\name{npt}
\alias{npt}
\title{The nonparametric trend test based on the nonparametric
risk under a given genetic model}
\usage{
npt(y, g, varphi)
}
\arguments{
\item{y}{a numeric vector of the observed quantitative trait
values in which the \emph{i}th element corresponds to the trait
value of the \emph{i}th subject.}

\item{g}{a numeric vector of the observed genotype values (0, 1,
or 2 denotes the number of risk alleles) in which the \emph{i}th
element is the genotype value of the \emph{i}th subject for a
biallelic SNP. \code{g} has the same length as \code{y}.}

\item{varphi}{a numeric value which represents the genetic
model. It should be 0, 0.5, or 1, which indicates that the
calculation is performed under the recessive, additive, or
dominant model, respectively. The default is 0.5.}
}
\value{
A list of \code{test.stat} and
\code{p.val}. \code{test.stat} is the observed value of the test
statistic and \code{p.val} is the p-value of the test.
}
\description{
Test for the association between a genetic variant and a
non-normal distributed quantitative trait based on the
nonparametric risk under a specific genetic model.
}
\details{
For a non-normal distributed quantitative trait, three genetic
models (recessive, additive and dominant) used commonly are
defined in terms of the nonparametric risk (NR). The recessive,
additive, and dominant models can be classified based on the
nonparametric risks. More specifically, the recessive, additive,
and dominant models refer to NR20> NR10=1/2, NR12= NR10>1/2, and
NR10= NR20>1/2, respectively, where NR10 and NR20 are the
nonparametric risks of the groups with the genotypes 1 and 2
relative to the group with the genotype 0, respectively, and NR12
is the nonparametric risk of the group with the genotype 2
relative to the group with the genotype 1.

\code{varphi} can be 0, 0.5, or 1 for the recessive, additive, or
dominant model, respectively. When \code{varphi} is 0, the test is
constructed under the recessive model by pooling together the
subjects with the genotypes 0 and 1. Similarly, when \code{varphi}
is 1, the test is constructed under the dominant model by pooling
together the subjects with the genotypes 1 and 2. When
\code{varphi} is 0.5, the test is based on the weighted sum of
NR10 and NR12.
}
\examples{
g <- rbinom(1500, 2, 0.3)
y <- 0.5 + 0.25 * g + rgev(1500, 0, 0, 5)
npt(y, g, varphi = 0.5)
}
\author{
Lin Wang, Wei Zhang, and Qizhai Li.
}

