% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/SMT_main.R
\name{smt}
\alias{smt}
\title{Single-marker test}
\usage{
smt(y, g, covariates = NULL, min.count = 5, missing.rate = 0.2,
  y.continuous = FALSE)
}
\arguments{
\item{y}{a numeric vector of the observed trait values in which
the \emph{i}th element is for the \emph{i}th subject. The elements
could be discrete (0 or 1) or continuous. The missing value is
represented by NA.}

\item{g}{a numeric vector of the observed genotype values (0, 1,
or 2 denotes the number of risk alleles) in which the \emph{i}th
element is for the \emph{i}th subject.  The missing value is
represented by NA. \code{g} has the same length as \code{y}.}

\item{covariates}{an optional data frame, list or environment
containing the covariates used in the model. The default is NULL,
that is, there are no covariates.}

\item{min.count}{a critical value to decide which method is used
to calculate the p-value when the trait is discrete and covariates
= NULL. If the minimum number of the elements given a specific
trait value and a specific genotype value is less than
\code{min.count}, the Fisher exact test is adopted; otherwise, the
Wald test is adopted.}

\item{missing.rate}{the highest missing rate of the genotype
values that this function can tolerate.}

\item{y.continuous}{logical. If TRUE, \code{y} is continuous;
otherwise, \code{y} is discrete.}
}
\value{
\code{smt} returns a list.

If y is continuous, the list contains the following components:
\tabular{llll}{
n0 \tab \tab \tab the number of the subjects used for the calculation with the genotype 0.\cr
n1 \tab \tab \tab the number of the subjects used for the calculation with the genotype 1.\cr
n2 \tab \tab \tab the number of the subjects used for the calculation with the genotype 2.\cr
p.val \tab \tab \tab the p-value of the single-marker test.
}
If y is discrete, the list contains the following components:
\tabular{llll}{
r0 \tab \tab \tab the number of the subjects used for the calculation with the trait value 1 and the genotype 0.\cr
r1 \tab \tab \tab the number of the subjects used for the calculation with the trait value 1 and the genotype 1.\cr
r2 \tab \tab \tab the number of the subjects used for the calculation with the trait value 1 and the genotype 2.\cr
r.miss \tab \tab \tab the number of the missing genotype values with the trait value 1.\cr
s0 \tab \tab \tab the number of the subjects used for the calculation with the trait value 0 and the genotype 0.\cr
s1 \tab \tab \tab the number of the subjects used for the calculation with the trait value 0 and the genotype 1.\cr
s2 \tab \tab \tab the number of the subjects used for the calculation with the trait value 0 and the genotype 2.\cr
s.miss \tab \tab \tab the number of the missing genotype values with the trait value 0.\cr
n.miss \tab \tab \tab the total number of the missing genotype values. \cr
p.val \tab \tab \tab the p-value of the single-marker test.
}
}
\description{
Conduct the single-marker test in an association study to test for
the association between the genotype at a biallelic marker and a
trait.
}
\details{
Single-marker analysis is a core in many gene-based or
pathway-based procedures, such as the truncated p-value
combination and the minimal p-value.
}
\examples{
y <- rep(c(0, 1), 25)
g <- sample(c(0, 1, 2), 50, replace = TRUE)
smt(y, g, covariates = NULL, min.count=5,
        missing.rate=0.20, y.continuous = FALSE)
}
\author{
Lin Wang, Wei Zhang, and Qizhai Li.
}

