% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoScore_Ordinal.R
\name{AutoScore_testing_Ordinal}
\alias{AutoScore_testing_Ordinal}
\title{AutoScore STEP(v) for ordinal outcomes: Evaluate the final score
  (AutoScore Module 6)}
\usage{
AutoScore_testing_Ordinal(
  test_set,
  final_variables,
  link = "logit",
  cut_vec,
  scoring_table,
  with_label = TRUE,
  n_boot = 100
)
}
\arguments{
\item{test_set}{A processed data.frame that contains data for testing
purpose. This data.frame should have same format as train_set (same
variable names and outcomes)}

\item{final_variables}{A vector containing the list of selected variables,
selected from Step(ii) \code{\link{AutoScore_parsimony_Ordinal}}.}

\item{link}{The link function used to model ordinal outcomes. Default is
\code{"logit"} for proportional odds model. Other options are
\code{"cloglog"} (proportional hazards model) and \code{"probit"}.}

\item{cut_vec}{Generated from STEP(iii) \code{\link{AutoScore_weighting_Ordinal}}.}

\item{scoring_table}{The final scoring table after fine-tuning, generated
from STEP(iv) \code{\link{AutoScore_fine_tuning_Ordinal}}.Please follow the
guidebook}

\item{with_label}{Set to TRUE if there are labels in the test_set and
performance will be evaluated accordingly (Default:TRUE).}

\item{n_boot}{Number of bootstrap cycles to compute 95\% CI for performance
metrics.}
}
\value{
A data frame with predicted score and the outcome for downstream visualization.
}
\description{
AutoScore STEP(v) for ordinal outcomes: Evaluate the final score
  (AutoScore Module 6)
}
\examples{
## Please see the guidebook or vignettes
}
\references{
\itemize{
 \item{Saffari SE, Ning Y, Feng X, Chakraborty B, Volovici V, Vaughan R, Ong
       ME, Liu N, AutoScore-Ordinal: An interpretable machine learning framework for
       generating scoring models for ordinal outcomes, arXiv:2202.08407}
}
}
\seealso{
\code{\link{AutoScore_rank_Ordinal}},
  \code{\link{AutoScore_parsimony_Ordinal}},
  \code{\link{AutoScore_weighting_Ordinal}},
  \code{\link{AutoScore_fine_tuning_Ordinal}}.
}
