% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainrunfunctions.R
\name{combine_inertialprop}
\alias{combine_inertialprop}
\title{Combine body and wing inertial components.}
\usage{
combine_inertialprop(
  curr_torsotail_data,
  left_wing_data,
  right_wing_data,
  dat_id_curr,
  dat_bird_curr,
  symmetric
)
}
\arguments{
\item{curr_torsotail_data}{{Output dataframe from massprop_restbody.}}

\item{left_wing_data}{{Output dataframe from massprop_birdwing.}}

\item{right_wing_data}{{Output dataframe from massprop_birdwing.}}

\item{dat_id_curr}{Dataframe related to the current bird wing ID
info that must include the following columns:
\itemize{
\item{species}{Species ID code as a string.}
\item{BirdID}{Bird ID code as a string.}
\item{TestID}{Test ID code as a string.}
\item{frameID}{Video frame ID code as a string.}
}}

\item{dat_bird_curr}{Dataframe related to the current bird wing that must
include the following columns:
\itemize{
\item{total_bird_mass}{Mass of full bird for the current wing (kg).}
}}

\item{symmetric}{{Logical indicating if the input wings are symmetric or not.
If True than left_wing_data = right_wing_data.}}
}
\value{
a dataframe containing all of the inertial properties for each wing
component and the full bird about it's center of gravity and the vehicle
reference point (VRP)
}
\description{
Combines data exported from massprop_restbody
and massprop_birdwing.
}
\examples{
# refer to the vignette
library(AvInertia)

# load data
data(dat_id_curr, package = "AvInertia")
data(dat_bird_curr, package = "AvInertia")
data(dat_feat_curr, package = "AvInertia")
data(dat_bone_curr, package = "AvInertia")
data(dat_mat, package = "AvInertia")
data(clean_pts, package = "AvInertia")

# 1. Determine the center of gravity of the bird's torso (including the legs)
dat_torsotail_out = massprop_restbody(dat_id_curr, dat_bird_curr)
# 2. Calculate the inertia of the flight feathers about the tip of the calamus
feather_inertia <- compute_feat_inertia(dat_mat, dat_feat_curr, dat_bird_curr)
# 3. Determine the center of gravity of one of the bird's wings
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = 0)
# Visualize the center of gravity of each wing component in the x and y axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yx")
# or the y and z axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yz")
# 4. Combine all data and obtain the center of gravity, moment of inertia
# and principal axes of the bird
curr_full_bird      = combine_inertialprop(dat_torsotail_out,dat_wing_out,
dat_wing_out, dat_id_curr, dat_bird_curr, symmetric=TRUE)

}
