% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anatomicalmassprop.R
\name{massprop_neck}
\alias{massprop_neck}
\title{Neck mass properties}
\usage{
massprop_neck(m, r, l, start, end)
}
\arguments{
\item{m}{Mass of muscle (kg).}

\item{r}{Radius of the neck (m).}

\item{l}{Length of the stretched neck (m).}

\item{start}{a 1x3 vector (x,y,z) representing the 3D point where neck starts. Frame of reference: VRP | Origin: VRP.}

\item{end}{a 1x3 vector (x,y,z) representing the 3D point where neck ends. Frame of reference: VRP | Origin: VRP.}
}
\value{
This function returns a list that includes:
\itemize{
\item{I}{a 3x3 matrix representing the moment of inertia tensor of a neck modeled as a solid cylinder.}
\item{CG}{a 1x3 vector representing the center of gravity position of a neck modeled as a solid cylinder.}
\item{m}{a double that returns the neck mass.}
}
}
\description{
Calculate the moment of inertia of a neck modeled as a solid cylinder
}
\section{Warning}{

Parallel axis theorem does not apply between two arbitrary points. One point must be the object's center of gravity.
}

\author{
Christina Harvey
}
