% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anatomicalmassprop.R
\name{orient_feather}
\alias{orient_feather}
\title{Determine the feather orientation}
\usage{
orient_feather(no_pri, no_sec, Pt1, Pt2, Pt3, Pt4, Pt8, Pt9, Pt10, Pt11, Pt12)
}
\arguments{
\item{no_pri}{a scalar representing the amount of primary feathers.}

\item{no_sec}{a scalar representing the amount of secondary feathers.}

\item{Pt1}{a 1x3 vector (x,y,z) representing the point on the
shoulder joint (m).}

\item{Pt2}{a 1x3 vector (x,y,z) representing the point on the
elbow joint (m).}

\item{Pt3}{a 1x3 vector (x,y,z) representing the point on the
wrist joint (m).}

\item{Pt4}{a 1x3 vector (x,y,z) representing the point on the
end of carpometacarpus (m).}

\item{Pt8}{a 1x3 vector (x,y,z) representing the point on tip
of most distal primary (m).}

\item{Pt9}{a 1x3 vector (x,y,z) representing the point on the tip
of the last primary to model as if it is on the end of the carpometacarpus (m).}

\item{Pt10}{1x3 vector (x,y,z) representing the point on tip
of last primary to model as if it was distributed along the carpometacarpus (m).
Usually the first secondary feather tip.}

\item{Pt11}{1x3 vector (x,y,z) representing the point on
tip of most proximal secondary feather (m).}

\item{Pt12}{1x3 vector (x,y,z) representing the point on
exterior shoulder position (wing root leading edge) (m).}
}
\value{
a list called "feather". This contains three matrices.
\enumerate{
\item "loc_start" a matrix defining the 3D point where each feather starts.
Rows are the different feathers and columns are x, y, z coordinates
respectively.
\item "loc_end" a matrix defining the 3D point where each feather end.
Rows are the different feathers and columns are x, y, z coordinates
respectively.
\item "normal" a matrix that gives the vector that defines the normal to
each feather plane.  Rows are the different feathers and columns are x, y, z
vector directions respectively.
}
}
\description{
Code that returns the orientation of each primary and secondary feather on the wing.
}
\examples{
# refer to the vignette
library(AvInertia)

# load data
data(dat_id_curr, package = "AvInertia")
data(dat_bird_curr, package = "AvInertia")
data(dat_feat_curr, package = "AvInertia")
data(dat_bone_curr, package = "AvInertia")
data(dat_mat, package = "AvInertia")
data(clean_pts, package = "AvInertia")

# 1. Determine the center of gravity of the bird's torso (including the legs)
dat_torsotail_out = massprop_restbody(dat_id_curr, dat_bird_curr)
# 2. Calculate the inertia of the flight feathers about the tip of the calamus
feather_inertia <- compute_feat_inertia(dat_mat, dat_feat_curr, dat_bird_curr)
# 3. Determine the center of gravity of one of the bird's wings
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = 0)
# Visualize the center of gravity of each wing component in the x and y axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yx")
# or the y and z axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yz")
# 4. Combine all data and obtain the center of gravity, moment of inertia
# and principal axes of the bird
curr_full_bird      = combine_inertialprop(dat_torsotail_out,dat_wing_out,
dat_wing_out, dat_id_curr, dat_bird_curr, symmetric=TRUE)

}
\author{
Christina Harvey
}
