% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainrunfunctions.R
\name{store_data}
\alias{store_data}
\title{Store data from the inertia calculations in long format}
\usage{
store_data(dat_wingID_curr, dat_mass, mass_properties, name)
}
\arguments{
\item{dat_wingID_curr}{Dataframe related to the current bird wing ID
info that must include the following columns:
\itemize{
\item{species}{Species ID code as a string}
\item{BirdID}{Bird ID code as a string}
\item{TestID}{Test ID code as a string}
\item{frameID}{Video frame ID code as a string}
}}

\item{dat_mass}{Dataframe containing the new MOI and CG data to add
to mass_properties as new rows. Must include:
\itemize{
\item{I}{Moment of inertia tensor (kg-m^2)}
\item{CG}{Center of gravity with three location components (m)}
}}

\item{mass_properties}{Dataframe containing any previously saved data.
Must have the following columns: "species","BirdID","TestID","FrameID",
"prop_type","component","value".}

\item{name}{Name of the component for which the moment of inertia and
center of gravity were computed.}
}
\value{
This function returns mass_properties as an updated dataframe
with a new row corresponding to the dat_mass information
}
\description{
Function to store moment of inertia tensor and center of gravity vector
components in long format
}
\examples{
# refer to the vignette
library(AvInertia)

# load data
data(dat_id_curr, package = "AvInertia")
data(dat_bird_curr, package = "AvInertia")
data(dat_feat_curr, package = "AvInertia")
data(dat_bone_curr, package = "AvInertia")
data(dat_mat, package = "AvInertia")
data(clean_pts, package = "AvInertia")

# 1. Determine the center of gravity of the bird's torso (including the legs)
dat_torsotail_out = massprop_restbody(dat_id_curr, dat_bird_curr)
# 2. Calculate the inertia of the flight feathers about the tip of the calamus
feather_inertia <- compute_feat_inertia(dat_mat, dat_feat_curr, dat_bird_curr)
# 3. Determine the center of gravity of one of the bird's wings
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = 0)
# Visualize the center of gravity of each wing component in the x and y axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yx")
# or the y and z axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yz")
# 4. Combine all data and obtain the center of gravity, moment of inertia
# and principal axes of the bird
curr_full_bird      = combine_inertialprop(dat_torsotail_out,dat_wing_out,
dat_wing_out, dat_id_curr, dat_bird_curr, symmetric=TRUE)

}
