% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_kubernetes_service.R
\name{aks_pools}
\alias{aks_pools}
\title{Utility function for specifying Kubernetes agent pools}
\usage{
aks_pools(name, count, size = "Standard_DS2_v2", os = "Linux")
}
\arguments{
\item{name}{The name(s) of the pool(s).}

\item{count}{The number of nodes per pool.}

\item{size}{The VM type (size) to use for the pool. To see a list of available VM sizes, use the \link{list_vm_sizes} method for the resource group or subscription classes.}

\item{os}{The operating system to use for the pool. Can be "Linux" or "Windows".}
}
\value{
A list of lists, suitable for passing to the \code{create_aks} constructor method.
}
\description{
Utility function for specifying Kubernetes agent pools
}
\details{
This is a convenience function to simplify the task of specifying the agent pool for a Kubernetes cluster. You can specify multiple pools by providing vectors as input arguments; any scalar inputs will be replicated to match.
}
\examples{
# 1 pool of 5 Linux VMs
aks_pools("pool1", 5)

# 1 pool of 3 Windows Server VMs
aks_pools("pool1", 3, os="Windows")

# 2 pools with different VM sizes per pool
aks_pools(c("pool1", "pool2"), count=c(3, 3), size=c("Standard_DS2_v2", "Standard_DS3_v2"))

}
\seealso{
\link{list_vm_sizes}
}
