% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ext_tools.R
\name{call_docker}
\alias{call_docker}
\title{Call the docker commandline tool}
\usage{
call_docker(cmd = "", ..., echo = TRUE)
}
\arguments{
\item{cmd}{The docker command line to execute.}

\item{...}{Other arguments to pass to \link[processx:run]{processx::run}.}

\item{echo}{Whether to echo the output of the command to the console.}
}
\value{
A list with the following components:
\itemize{
\item \code{status}: The exit status of the docker tool. If this is \code{NA}, then the process was killed and had no exit status.
\item \code{stdout}: The standard output of the command, in a character scalar.
\item \code{stderr}: The standard error of the command, in a character scalar.
\item \code{timeout}: Whether the process was killed because of a timeout.
\item \code{cmdline}: The command line.
}

The first four components are from \code{processx::run}; AzureContainers adds the last to make it easier to construct scripts that can be run outside R.
}
\description{
Call the docker commandline tool
}
\details{
This function calls the \code{docker} binary, which must be located in your search path. AzureContainers will search for the binary at package startup, and print a warning if it is not found.
}
\examples{
\dontrun{

# without any args, prints the docker help screen
call_docker()

# build an image
call_docker("build -t myimage .")

# list running containers
call_docker("container ls")

# prune unused containers and images
call_docker("container prune -f")
call_docker("image prune -f")

}
}
\seealso{
\link[processx:run]{processx::run}, \link{call_docker_compose}, \link{call_kubectl} for the equivalent interface to the \code{kubectl} Kubernetes tool

\link{docker_registry}

\href{https://docs.docker.com/engine/reference/commandline/cli/}{Docker command line reference}
}
