% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/az_container_registry.R
\docType{class}
\name{acr}
\alias{acr}
\alias{az_container_registry}
\title{Azure Container Registry class}
\description{
Class representing an Azure Container Registry (ACR) resource. For working with the registry endpoint itself, including uploading and downloading images etc, see \link{docker_registry}.
}
\section{Methods}{

The following methods are available, in addition to those provided by the \link[AzureRMR:az_resource]{AzureRMR::az_resource} class:
\itemize{
\item \code{new(...)}: Initialize a new ACR object. See 'Details'.
\item \code{add_role_assignment(principal, role, scope=NULL, ...)}: Adds a role for the specified principal. This is an override mainly to handle AKS objects, so that the Kubernetes cluster can be granted access to the registry. You can use the \code{...} arguments to supply authentication details for AzureGraph, which is used to retrieve the cluster service principal.
\item \code{list_credentials}: Return the username and passwords for this registry. Only valid if the Admin user for the registry has been enabled.
\item \code{list_policies}: Return the policies for this registry.
\item \code{list_usages}: Return the usage for this registry.
\item \code{get_docker_registry(username, password)}: Return an object representing the Docker registry endpoint.
}
}

\section{Details}{

Initializing a new object of this class can either retrieve an existing registry resource, or create a new registry on the host. Generally, the best way to initialize an object is via the \code{get_acr}, \code{create_acr} or \code{list_acrs} methods of the \link{az_resource_group} class, which handle the details automatically.

Note that this class is separate from the Docker registry itself. This class exposes methods for working with the Azure resource: listing credentials, updating resource tags, updating and deleting the resource, and so on.

For working with the registry, including uploading and downloading images, updating tags, deleting layers and images etc, use the endpoint object generated with \code{get_docker_registry}. This method takes two optional arguments:
\itemize{
\item \code{username}: The username that Docker will use to authenticate with the registry.
\item \code{password}: The password that Docker will use to authenticate with the registry.
}

By default, these arguments will be retrieved from the ACR resource. They will only exist if the resource was created with \code{admin_user_enabled=TRUE}. Currently AzureContainers does not support authentication methods other than a username/password combination.
}

\examples{
\dontrun{

rg <- AzureRMR::get_azure_login()$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

myacr <- rg$get_acr("myregistry")

myacr$list_credentials()
myacr$list_policies()

# see who has push and pull access
myacr$list_role_assignments()

# grant a Kubernetes cluster pull access
myaks <- rg$get_aks("myaks")
myacr$add_role_assignment(myaks, "Acrpull")

# get the registry endpoint (for interactive use)
myacr$get_docker_registry()

# get the registry endpoint (admin user account)
myacr$get_docker_registry(as_admin=TRUE)

}
}
\seealso{
\link{create_acr}, \link{get_acr}, \link{delete_acr}, \link{list_acrs}

\link{docker_registry} for interacting with the Docker registry endpoint

\href{https://docs.microsoft.com/en-us/azure/container-registry/}{Azure Container Registry} and
\href{https://docs.microsoft.com/en-us/rest/api/containerregistry/registries}{API reference}
}
