% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_methods.R
\name{create_key_vault}
\alias{create_key_vault}
\title{Create Azure key vault}
\description{
Method for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} class.
}
\section{Usage}{
\preformatted{create_key_vault(name, location = self$location, initial_access = default_access(),
                 sku = "Standard", ..., wait = TRUE)
}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the key vault.
\item \code{location}: The location/region in which to create the account. Defaults to the resource group location.
\item \code{initial_access}: The user or service principals that will have access to the vault. This should be a list of objects of type \code{[vault_access_policy]}, created by the function of the same name. The default is to grant access to the logged-in user or service principal of the current Resource Manager client.
\item \code{sku}: The sku for the vault. Set this to "Premium" to enable the use of hardware security modules (HSMs).
\item \code{...}: Other named arguments to pass to the \link{az_key_vault} initialization function.
\item \code{wait}: Whether to wait for the resource creation to complete before returning.
}
}

\section{Details}{

This method deploys a new key vault resource, with parameters given by the arguments. A key vault is a secure facility for storing and managing encryption keys, certificates, storage account keys, and generic secrets.

A new key vault will have access granted to the user or service principal used to sign in to the Azure Resource Manager client. To manage access policies after creation, use the \code{add_principal}, \code{list_principals} and \code{remove_principal} methods of the key vault object.
}

\section{Value}{

An object of class \code{az_key_vault} representing the created key vault.
}

\examples{
\dontrun{

rg <- AzureRMR::get_azure_login()$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

# create a new key vault
rg$create_key_vault("mykeyvault")

# create a new key vault, and grant access to a service principal
gr <- AzureGraph::get_graph_login()
svc <- gr$get_service_principal("app_id")
rg$create_key_vault("mykeyvault",
    initial_access=list(vault_access_policy(svc, tenant=NULL)))

}
}
\seealso{
\link{get_key_vault}, \link{delete_key_vault}, \link{az_key_vault}, \link{vault_access_policy}

\href{https://docs.microsoft.com/en-us/azure/key-vault/}{Azure Key Vault documentation},
\href{https://docs.microsoft.com/en-us/rest/api/keyvault}{Azure Key Vault API reference}
}
