% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/consume.R
\name{consumeFile}
\alias{consumeFile}
\title{Use a web service to score a file}
\usage{
consumeFile(apiKey, requestUrl, inFileName, globalParam = setNames(list(),
  character(0)), outputFileName = "results.csv", batchSize = 300,
  retryDelay = 0.3)
}
\arguments{
\item{apiKey}{primary access key as a string}

\item{requestUrl}{API URL}

\item{inFileName}{the name of the file to be scored as a string}

\item{globalParam}{global parameters entered as a list, default value is an empty list}

\item{outputFileName}{the name of the file to output results to, entered as a string, default value is "results.csv"}

\item{batchSize}{batch size of each batch, default value is 300}

\item{retryDelay}{the time in seconds to delay before retrying in case of a server error, default value is 0.3 seconds}
}
\value{
returnDataFrame data frame containing results returned from web service call
}
\description{
Read in a csv and score it in batches using a Microsoft Azure Machine Learning Web Service. The results are stored in a new csv, default named "results.csv"
}
\examples{
\dontrun{
add <- function(x,y) { return(x+y) }
newService <- publishWebService("add", "add",
 list("x"="int","y"="int"), list("z"="int"), wsID, authToken)
webserviceDetails <- newService[[1]]
endpoints <- newService[[2]]

response <- consumeFile(endpoints[[1]]$PrimaryKey, endpoints[[1]]$ApiLocation, "test.csv")
}
}
\seealso{
\code{\link{discoverSchema}} \code{\link{publishWebService}}

Other consumption functions: \code{\link{consumeDataframe}};
  \code{\link{consumeLists}}
}

