% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/publish.R
\name{updateWebService}
\alias{updateWebService}
\title{Update a Published Web Service}
\usage{
updateWebService(functionName, serviceName, wsID, inputSchema, outputSchema,
  wkID, authToken)
}
\arguments{
\item{functionName}{function name as a string to be published}

\item{serviceName}{name of the new web service}

\item{wsID}{ID of the web service to be updated}

\item{inputSchema}{list of input parameters of format \code{list("arg1"="type", "arg2"="type", ...)}}

\item{outputSchema}{list of outputs of format \code{list("output1"="type", "output2"="type", ...)}}

\item{wkID}{the workspace ID}

\item{authToken}{primary authorization token}
}
\value{
List of webservice details, default endpoint details, and the consumption function
}
\description{
Update a web service, i.e. change the underlying R code that the service will run when called. The same restrictions that apply to publishWebService() also apply to updateWebService()
}
\examples{
\dontrun{
add1 <- function(x) { return(x+1) }
addService <- publishWebService("add1", "add1",
 list("x"="int"), list("z"="int"), wsID, wsAuth)

add2 <- function(x) { return(x+2) }
addService <- updateWebService("add2", "add2", addService[[1]]$Id,
 list("x"="int"), list("z"="int"), wsID, wsAuth)
}
}
\seealso{
\code{\link{getWSDetails}} \code{\link{getEndpoints}} \code{\link{discoverSchema}} \code{\link{consumeLists}}

Other publishing functions: \code{\link{publishWebService}}
}

