% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/workspace.R
\name{datasets}
\alias{datasets}
\title{List datasets in an AzureML workspace.}
\usage{
datasets(ws, filter = c("all", "my datasets", "samples"))
}
\arguments{
\item{ws}{An AzureML workspace reference returned by \code{\link{workspace}}.}

\item{filter}{Optionally filter result, returing all, mine, or sample datasets.}
}
\value{
A data.frame with class \code{Datasets} listing available datasets in the workspace.
}
\description{
List datasets in an AzureML workspace, optionally filtering on sample or my datasets.
}
\note{
\code{datasets(w)} is equivalent to \code{w$datasets}. Since \code{w$datasets} is simply
an R data.frame, you can alternatively filter on any variable as desired.
}
\examples{
\dontrun{
  library(AzureML)
  
  # Use the default config file ~/azureml/settings.json with format:
  #   {"workspace":{
  #     "id":"test_id",
  #     "authorization_token": "test_token",
  #     "api_endpoint":"api_endpoint",
  #     "management_endpoint":"management_endpoint"
  #    }}
  # or, optionally set the `id` and `auth` parameters in the workspace
  # function.
  ws <- workspace()
  
  # List datasets
  ws$datasets
  datasets(ws)
  
  dataset <- "New York weather"
  ds <- match(dataset, ws$datasets$Name)
  frame <- download.datasets(ws$datasets[ds, ])
  head(frame)

  # Alternative approach:
  frame <- download.datasets(ws, name=dataset)
  head(frame)
}
}
\seealso{
\code{\link{workspace}}, \code{\link{experiments}}, \code{\link{download.datasets}}

Other dataset functions: \code{\link{delete.datasets}};
  \code{\link{download.intermediate.dataset}};
  \code{\link{upload.dataset}}; \code{\link{workspace}}
}

